class CelebritiesController < ApplicationController
  # GET /celebrity
  # GET /celebrity.xml
  def index
    @celebrities = Celebrity.find(:all)
    
    # get celebrities with final image url for extjs client
    return_data = Array.new()
    @celebrities.each do |celebrity|
      return_data << { :celebrity => { :name => celebrity.name, :id => celebrity.id, :image_url => celebrity.image.url(:thumb) }}
    end
    
    respond_to do |format|
      format.html # index.haml
      format.xml  { render :xml => @celebrities }
      format.json { render :json => return_data }
    end
  end

  # GET /celebrity/1
  # GET /celebrity/1.xml
  def show
    @celebrity = Celebrity.find(params[:id])

    respond_to do |format|
      format.html # show.haml
      format.xml  { render :xml => @celebrity }
      format.json { render :json => @celebrity }
    end
  end

  # GET /celebrity/new
  # GET /celebrity/new.xml
  def new
    @celebrity = Celebrity.new

    respond_to do |format|
      format.html # new.haml
      format.xml  { render :xml => @celebrity }
    end
  end

  # GET /celebrity/1/edit
  def edit
    @celebrity = Celebrity.find(params[:id])
  end

  # POST /celebrity
  # POST /celebrity.xml
  def create
    @celebrity = Celebrity.new(params[:celebrity])

    respond_to do |format|
      if @celebrity.save
        flash[:notice] = 'Celebrity was successfully created.'
        format.html { redirect_to(celebrity_path( @celebrity )) }
        format.xml  { render :xml => @celebrity, :status => :created, :location => @celebrity }
      else
        format.html { render :action => "new" }
        format.xml  { render :xml => @celebrity.errors, :status => :unprocessable_entity }
      end
    end
  end

  # PUT /celebrity/1
  # PUT /celebrity/1.xml
  def update
    @celebrity = Celebrity.find(params[:id])

    respond_to do |format|
      if @celebrity.update_attributes(params[:celebrity])
        flash[:notice] = 'Celebrity was successfully updated.'
        format.html { redirect_to(celebrity_path(@celebrity)) }
        format.xml  { head :ok }
      else
        format.html { render :action => "edit" }
        format.xml  { render :xml => @celebrity.errors, :status => :unprocessable_entity }
      end
    end
  end

  # DELETE /celebrity/1
  # DELETE /celebrity/1.xml
  def destroy
    @celebrity = Celebrity.find(params[:id])
    @celebrity.destroy

    respond_to do |format|
      format.html { redirect_to(celebrities_url) }
      format.xml  { head :ok }
    end
  end
  
end
