class SecretariesController < ApplicationController
  # GET /secretary
  # GET /secretary.xml
  def index
    @secretaries = Secretary.find(:all)

    # get secretaries, create image url, get best three votings for secretary
    return_data = Array.new()
    @secretaries.each do |secretary|
      return_data << build_votings_for_secretary( secretary )
    end

    respond_to do |format|
      format.html # index.haml
      format.xml  { render :xml => @secretaries }
      format.json { render :json => return_data }
    end
  end

  # GET /secretary/1
  # GET /secretary/1.xml
  def show
    @secretary = Secretary.find(params[:id])

    respond_to do |format|
      format.html # show.haml
      format.xml  { render :xml => @secretary }
      format.json { render :json => @secretary }
    end
  end

  # GET /secretary/new
  # GET /secretary/new.xml
  def new
    @secretary = Secretary.new

    respond_to do |format|
      format.html # new.haml
      format.xml  { render :xml => @secretary }
      format.json { render :json => @secretary }
    end
  end

  # GET /secretary/1/edit
  def edit
    @secretary = Secretary.find(params[:id])
  end

  # POST /secretary
  # POST /secretary.xml
  def create
    @secretary = Secretary.new(params[:secretary])

    respond_to do |format|
      if @secretary.save
        flash[:notice] = 'Secretary was successfully created.'
        format.html { redirect_to(secretary_path(@secretary)) }
        format.xml  { render :xml => @secretary, :status => :created, :location => @secretary }
      else
        format.html { render :action => "new" }
        format.xml  { render :xml => @secretary.errors, :status => :unprocessable_entity }
      end
    end
  end

  # PUT /secretary/1
  # PUT /secretary/1.xml
  def update
    @secretary = Secretary.find(params[:id])

    respond_to do |format|
      if @secretary.update_attributes(params[:secretary])
        flash[:notice] = 'Secretary was successfully updated.'
        format.html { redirect_to(secretary_path(@secretary)) }
        format.xml  { head :ok }
      else
        format.html { render :action => "edit" }
        format.xml  { render :xml => @secretary.errors, :status => :unprocessable_entity }
      end
    end
  end

  # DELETE /secretary/1
  # DELETE /secretary/1.xml
  def destroy
    @secretary = Secretary.find(params[:id])
    @secretary.destroy

    respond_to do |format|
      format.html { redirect_to(secretaries_url) }
      format.xml  { head :ok }
    end
  end
  
  private   
  
  def build_votings_for_secretary( secretary )
    tmp_object = Hash.new
    tmp_object[:secretary] = { :name => secretary.name, :id => secretary.id }
    tmp_object[:secretary][:votes] = Array.new
        
    votings = Voting.find_by_sql("SELECT celebrity_id, count(id) AS votes FROM votings WHERE secretary_id = #{secretary.id} GROUP BY celebrity_id ORDER BY votes DESC LIMIT 3")
    votings.each do |voting|
      tmp_object[:secretary][:votes] << { 
        :name => voting.celebrity.name, 
        :image_url => voting.celebrity.image.url(:thumb), 
        :count => secretary.votings.find(:all, :conditions => "celebrity_id = #{voting.celebrity.id}").length 
      }
    end
    
    logger.debug "tmp object: " + tmp_object.inspect
    
    tmp_object
  end
  
end
