class VotingsController < ApplicationController
  protect_from_forgery :except => [:create]
  
  # GET /voting
  # GET /voting.xml
  def index
        
    if params[:secretary_id]
      @secretary = Secretary.find(params[:secretary_id])
      @votings = Voting.find(:all, :conditions => "secretary_id = '#{@secretary.id}'")
    elsif params[:celebrity_id]
      @celebrity = Celebrity.find(params[:celebrity_id])
      @votings = Voting.find(:all, :conditions => "celebrity_id = '#{@celebrity.id}'")
    else
      @votings = Voting.find(:all)
    end
        
    respond_to do |format|
      format.html # index.haml
      format.xml  { render :xml => @votings }
      format.json { render :json => @votings }
    end
  end

  # GET /voting/1
  # GET /voting/1.xml
  def show
    @voting = Voting.find(params[:id])

    respond_to do |format|
      format.html # show.haml
      format.xml  { render :xml => @voting }
      format.json { render :json => @voting }
    end
  end

  # GET /voting/new
  # GET /voting/new.xml
  def new
    @voting = Voting.new

    respond_to do |format|
      format.html # new.haml
      format.xml  { render :xml => @voting }
    end
  end

  # GET /voting/1/edit
  def edit
    @voting = Voting.find(params[:id])
  end

  # POST /voting
  # POST /voting.xml
  def create
    #@voting = Voting.new(params[:voting])
    @voting = Voting.new
    @voting.secretary_id = params[:secretary_id]
    @voting.celebrity_id = params[:celebrity_id]

    respond_to do |format|
      if @voting.save
        flash[:notice] = 'Voting was successfully created.'
        format.html { redirect_to(votings_path) }
        format.xml  { render :xml => @voting, :status => :created, :location => @voting }
        format.json { render :json => '' }
      else
        format.html { render :action => "new" }
        format.xml  { render :xml => @voting.errors, :status => :unprocessable_entity }
        format.json { render :json => '' }
      end
    end
  end

  # PUT /voting/1
  # PUT /voting/1.xml
  def update
    @voting = Voting.find(params[:id])

    respond_to do |format|
      if @voting.update_attributes(params[:voting])
        flash[:notice] = 'Voting was successfully updated.'
        format.html { redirect_to(votings_path) }
        format.xml  { head :ok }
      else
        format.html { render :action => "edit" }
        format.xml  { render :xml => @voting.errors, :status => :unprocessable_entity }
      end
    end
  end

  # DELETE /voting/1
  # DELETE /voting/1.xml
  def destroy
    @voting = Voting.find(params[:id])
    @voting.destroy

    respond_to do |format|
      format.html { redirect_to(votings_url) }
      format.xml  { head :ok }
    end
  end
end
