set :stages, %w(staging production)
set :default_stage, "production"
require 'capistrano/ext/multistage'

namespace :deploy do
  desc "Take site down, update, create slugs, delete old slugs, restart, take site up"
  task :default do
    on_rollback do
      #web.disable
    end
    
    transaction do
      update_code
      #web.disable
      symlink
      restart
      #web.enable
    end
  end
  
  namespace :web do
    desc <<-DESC
      Present a maintenance page to visitors. Disables your application's web \
      interface by writing a "maintenance.html" file to each web server. The \
      servers must be configured to detect the presence of this file, and if \
      it is present, always display it instead of performing the request.
    DESC
    task :disable, :roles => :web, :except => { :no_release => true } do
     invoke_command "cp #{current_path}/config/templates/* #{shared_path}/system/"
    end
    
    task :enable, :roles => :web, :except => { :no_release => true } do
      run "rm #{shared_path}/system/maintenance*.html"
    end
  end  
end


namespace :db do
  desc 'Dumps the production database to db/production_data.sql on the remote server'
  task :remote_db_dump, :roles => :db, :only => { :primary => true } do
    run "cd #{deploy_to}/#{current_dir} && " +
      "rake RAILS_ENV=#{rails_env} db:database_dump --trace" 
  end

  desc 'Downloads db/production_data.sql from the remote production environment to your local machine'
  task :remote_db_download, :roles => :db, :only => { :primary => true } do  
    execute_on_servers(options) do |servers|
      self.sessions[servers.first].sftp.connect do |tsftp|
        tsftp.download!("#{deploy_to}/#{current_dir}/db/production_data.sql", "db/production_data.sql")
      end
    end
  end

  desc 'Cleans up data dump file'
  task :remote_db_cleanup, :roles => :db, :only => { :primary => true } do
    execute_on_servers(options) do |servers|
      self.sessions[servers.first].sftp.connect do |tsftp|
        tsftp.remove! "#{deploy_to}/#{current_dir}/db/production_data.sql" 
      end
    end
  end 

  desc 'Dumps, downloads and then cleans up the production data dump'
  task :remote_db_runner do
    remote_db_dump
    remote_db_download
    remote_db_cleanup
  end
end

namespace :misc do
  after "deploy:update_code", "misc:link_asset_paths"

  desc "link asset paths to admin app's asset paths"
  task :link_asset_paths, :roles => :web do
    invoke_command "ln -nfs #{shared_path}/assets #{release_path}/public/system"
  end
end
