#############################################################
#	Application
#############################################################

set :application, ""
set :deploy_to, ""

#############################################################
#	Settings
#############################################################

default_run_options[:pty] = true
ssh_options[:forward_agent] = true
set :use_sudo, true
set :scm_verbose, false
set :rails_env, "production"

#############################################################
#	Servers
#############################################################

set :user, ""
set :domain, ""
server domain, :app, :web
role :db, domain, :primary => true

#############################################################
#	SVN
#############################################################

load File.join(File.dirname(__FILE__), 'scm_config.rb')
set :repository, ""
set :deploy_via, :export

#############################################################
#	Git
#############################################################

# set :scm, :git
# set :branch, "master"
# set :scm_user, 'bort'
# set :scm_passphrase, "PASSWORD"
# set :repository, "git@github.com:FudgeStudios/bort.git"
# set :deploy_via, :remote_cache

#############################################################
#	Passenger
#############################################################

namespace :deploy do
  desc "Create the database yaml file"
  task :after_update_code do
    db_config = <<-EOF
    production:    
      adapter: mysql
      encoding: utf8
      username: meinkabinett
      password: 
      database: meinkabinett_production
      host: localhost
    EOF
    
    put db_config, "#{release_path}/config/database.yml"
    
    #########################################################
    # Uncomment the following to symlink an uploads directory.
    # Just change the paths to whatever you need.
    #########################################################
    
    # desc "Symlink the upload directories"
    # task :before_symlink do
    #   run "mkdir -p #{shared_path}/uploads"
    #   run "ln -s #{shared_path}/uploads #{release_path}/public/uploads"
    # end
  
  end
    
  # Restart passenger on deploy
  desc "Restarting mod_rails with restart.txt"
  task :restart, :roles => :app, :except => { :no_release => true } do
    run "touch #{current_path}/tmp/restart.txt"
  end
  
  [:start, :stop].each do |t|
    desc "#{t} task is a no-op with mod_rails"
    task t, :roles => :app do ; end
  end
  
end
