/**
 * @author schiesser
 */
Ext.ns('de.meinkabinett.view');

de.meinkabinett.view.VoteCelebrityView = Ext.extend(Ext.Window, {
    constructor: function(config){
        var that = this;
        var dataView = new Ext.DataView({
            store: de.meinkabinett.Model.celebrities,
            tpl: util.TemplateLoader.getTemplate('/templates/celebrity.tpl'),
            overClass: 'item-over',
            itemSelector: 'li.celebrity',
            id: 'celebrities',
			cls: 'modal_inner'
        });
        var filter = new Ext.form.TextField({
            selectOnFocus: true,
            enableKeyEvents: true,
            width: 100
        });
        
        de.meinkabinett.view.VoteCelebrityView.superclass.constructor.call(this, Ext.apply({
            resizable: false,
            closable: false,
            plain: true,
            draggable: false,
            modal: true,
            tbar: [{
                text: 'Filter:'
            }, filter],
            items: dataView,
            buttons: [{
                text: 'abbrechen',
                handler: function(){
                    that.hide();
                }
            }],
            width: 575,
			height: 400,
			autoScroll: true
        }, config));
        
        dataView.on('click', function(thisDataView, index, node){
            var celebrityId = dataView.getRecord(node).get('id');
            var secretaryId = de.meinkabinett.Model.selectedSecretaryId;
            Ext.Ajax.request({
                url: "/secretaries/" + secretaryId + "/votings",
                success: function(response){
                    that.hide();
					de.meinkabinett.Model.secretaries.reload();
                    Ext.MessageBox.alert('Danke', 'Vielen Dank für Ihre Stimme.');
                },
                failure: function(response){
                    that.hide();
                    Ext.MessageBox.alert('Fehler', 'Leider ist bei der Stimmabgabe ein Fehler aufgetreten. Bitte versuchen Sie es später nocheinmal.');
                },
                headers: {
                    'Accept': 'application/json'
                },
                method: 'POST',
                params: {
                    celebrity_id: celebrityId
                }
            });
        });
        
        filter.on('keyup', function(){
            de.meinkabinett.Model.celebrities.filter('name', filter.getValue(), true);
        });
        
    }
});

