require File.dirname(__FILE__) + '/../spec_helper'

describe SecretariesController, "#route_for" do

  it "should map { :controller => 'secretaries', :action => 'index' } to /secretaries" do
    route_for(:controller => "secretaries", :action => "index").should == "/secretaries"
  end
  
  it "should map { :controller => 'secretaries', :action => 'new' } to /secretaries/new" do
    route_for(:controller => "secretaries", :action => "new").should == "/secretaries/new"
  end
  
  it "should map { :controller => 'secretaries', :action => 'show', :id => 1 } to /secretaries/1" do
    route_for(:controller => "secretaries", :action => "show", :id => 1).should == "/secretaries/1"
  end
  
  it "should map { :controller => 'secretaries', :action => 'edit', :id => 1 } to /secretaries/1/edit" do
    route_for(:controller => "secretaries", :action => "edit", :id => 1).should == "/secretaries/1/edit"
  end
  
  it "should map { :controller => 'secretaries', :action => 'update', :id => 1} to /secretaries/1" do
    route_for(:controller => "secretaries", :action => "update", :id => 1).should == "/secretaries/1"
  end
  
  it "should map { :controller => 'secretaries', :action => 'destroy', :id => 1} to /secretaries/1" do
    route_for(:controller => "secretaries", :action => "destroy", :id => 1).should == "/secretaries/1"
  end
  
end

describe SecretariesController, "handling GET /secretaries" do

  before do
    @secretary = mock_model(Secretary)
    Secretary.stub!(:find).and_return([@secretary])
  end
  
  def do_get
    get :index
  end
  
  it "should be successful" do
    do_get
    response.should be_success
  end

  it "should render index template" do
    do_get
    response.should render_template('index')
  end
  
  it "should find all secretaries" do
    Secretary.should_receive(:find).with(:all).and_return([@secretary])
    do_get
  end
  
  it "should assign the found secretaries for the view" do
    do_get
    assigns[:secretaries].should == [@secretary]
  end
end

describe SecretariesController, "handling GET /secretaries.xml" do

  before do
    @secretary = mock_model(Secretary, :to_xml => "XML")
    Secretary.stub!(:find).and_return(@secretary)
  end
  
  def do_get
    @request.env["HTTP_ACCEPT"] = "application/xml"
    get :index
  end
  
  it "should be successful" do
    do_get
    response.should be_success
  end

  it "should find all secretaries" do
    Secretary.should_receive(:find).with(:all).and_return([@secretary])
    do_get
  end
  
  it "should render the found secretary as xml" do
    @secretary.should_receive(:to_xml).and_return("XML")
    do_get
    response.body.should == "XML"
  end
end

describe SecretariesController, "handling GET /secretaries/1" do

  before do
    @secretary = mock_model(Secretary)
    Secretary.stub!(:find).and_return(@secretary)
  end
  
  def do_get
    get :show, :id => "1"
  end

  it "should be successful" do
    do_get
    response.should be_success
  end
  
  it "should render show template" do
    do_get
    response.should render_template('show')
  end
  
  it "should find the secretary requested" do
    Secretary.should_receive(:find).with("1").and_return(@secretary)
    do_get
  end
  
  it "should assign the found secretary for the view" do
    do_get
    assigns[:secretary].should equal(@secretary)
  end
end

describe SecretariesController, "handling GET /secretaries/1.xml" do

  before do
    @secretary = mock_model(Secretary, :to_xml => "XML")
    Secretary.stub!(:find).and_return(@secretary)
  end
  
  def do_get
    @request.env["HTTP_ACCEPT"] = "application/xml"
    get :show, :id => "1"
  end

  it "should be successful" do
    do_get
    response.should be_success
  end
  
  it "should find the secretary requested" do
    Secretary.should_receive(:find).with("1").and_return(@secretary)
    do_get
  end
  
  it "should render the found secretary as xml" do
    @secretary.should_receive(:to_xml).and_return("XML")
    do_get
    response.body.should == "XML"
  end
end

describe SecretariesController, "handling GET /secretaries/new" do

  before do
    @secretary = mock_model(Secretary)
    Secretary.stub!(:new).and_return(@secretary)
  end
  
  def do_get
    get :new
  end

  it "should be successful" do
    do_get
    response.should be_success
  end
  
  it "should render new template" do
    do_get
    response.should render_template('new')
  end
  
  it "should create an new secretary" do
    Secretary.should_receive(:new).and_return(@secretary)
    do_get
  end
  
  it "should not save the new secretary" do
    @secretary.should_not_receive(:save)
    do_get
  end
  
  it "should assign the new secretary for the view" do
    do_get
    assigns[:secretary].should equal(@secretary)
  end
end

describe SecretariesController, "handling GET /secretaries/1/edit" do

  before do
    @secretary = mock_model(Secretary)
    Secretary.stub!(:find).and_return(@secretary)
  end
  
  def do_get
    get :edit, :id => "1"
  end

  it "should be successful" do
    do_get
    response.should be_success
  end
  
  it "should render edit template" do
    do_get
    response.should render_template('edit')
  end
  
  it "should find the secretary requested" do
    Secretary.should_receive(:find).and_return(@secretary)
    do_get
  end
  
  it "should assign the found secretary for the view" do
    do_get
    assigns[:secretary].should equal(@secretary)
  end
end

describe SecretariesController, "handling POST /secretaries" do

  before do
    @secretary = mock_model(Secretary, :to_param => "1")
    Secretary.stub!(:new).and_return(@secretary)
  end
  
  def post_with_successful_save
    @secretary.should_receive(:save).and_return(true)
    post :create, :secretary => {}
  end
  
  def post_with_failed_save
    @secretary.should_receive(:save).and_return(false)
    post :create, :secretary => {}
  end
  
  it "should create a new secretary" do
    Secretary.should_receive(:new).with({}).and_return(@secretary)
    post_with_successful_save
  end

  it "should redirect to the new secretary on successful save" do
    post_with_successful_save
    response.should redirect_to(secretary_url("1"))
  end

  it "should re-render 'new' on failed save" do
    post_with_failed_save
    response.should render_template('new')
  end
end

describe SecretariesController, "handling PUT /secretaries/1" do

  before do
    @secretary = mock_model(Secretary, :to_param => "1")
    Secretary.stub!(:find).and_return(@secretary)
  end
  
  def put_with_successful_update
    @secretary.should_receive(:update_attributes).and_return(true)
    put :update, :id => "1"
  end
  
  def put_with_failed_update
    @secretary.should_receive(:update_attributes).and_return(false)
    put :update, :id => "1"
  end
  
  it "should find the secretary requested" do
    Secretary.should_receive(:find).with("1").and_return(@secretary)
    put_with_successful_update
  end

  it "should update the found secretary" do
    put_with_successful_update
    assigns(:secretary).should equal(@secretary)
  end

  it "should assign the found secretary for the view" do
    put_with_successful_update
    assigns(:secretary).should equal(@secretary)
  end

  it "should redirect to the secretary on successful update" do
    put_with_successful_update
    response.should redirect_to(secretary_url("1"))
  end

  it "should re-render 'edit' on failed update" do
    put_with_failed_update
    response.should render_template('edit')
  end
end

describe SecretariesController, "handling DELETE /secretary/1" do

  before do
    @secretary = mock_model(Secretary, :destroy => true)
    Secretary.stub!(:find).and_return(@secretary)
  end
  
  def do_delete
    delete :destroy, :id => "1"
  end

  it "should find the secretary requested" do
    Secretary.should_receive(:find).with("1").and_return(@secretary)
    do_delete
  end
  
  it "should call destroy on the found secretary" do
    @secretary.should_receive(:destroy)
    do_delete
  end
  
  it "should redirect to the secretaries list" do
    do_delete
    response.should redirect_to(secretaries_url)
  end
end
