require File.dirname(__FILE__) + '/../spec_helper'

describe VotingsController, "#route_for" do

  it "should map { :controller => 'votings', :action => 'index' } to /votings" do
    route_for(:controller => "votings", :action => "index").should == "/votings"
  end
  
  it "should map { :controller => 'votings', :action => 'new' } to /votings/new" do
    route_for(:controller => "votings", :action => "new").should == "/votings/new"
  end
  
  it "should map { :controller => 'votings', :action => 'show', :id => 1 } to /votings/1" do
    route_for(:controller => "votings", :action => "show", :id => 1).should == "/votings/1"
  end
  
  it "should map { :controller => 'votings', :action => 'edit', :id => 1 } to /votings/1/edit" do
    route_for(:controller => "votings", :action => "edit", :id => 1).should == "/votings/1/edit"
  end
  
  it "should map { :controller => 'votings', :action => 'update', :id => 1} to /votings/1" do
    route_for(:controller => "votings", :action => "update", :id => 1).should == "/votings/1"
  end
  
  it "should map { :controller => 'votings', :action => 'destroy', :id => 1} to /votings/1" do
    route_for(:controller => "votings", :action => "destroy", :id => 1).should == "/votings/1"
  end
  
end

describe VotingsController, "handling GET /votings" do

  before do
    @voting = mock_model(Voting)
    Voting.stub!(:find).and_return([@voting])
  end
  
  def do_get
    get :index
  end
  
  it "should be successful" do
    do_get
    response.should be_success
  end

  it "should render index template" do
    do_get
    response.should render_template('index')
  end
  
  it "should find all votings" do
    Voting.should_receive(:find).with(:all).and_return([@voting])
    do_get
  end
  
  it "should assign the found votings for the view" do
    do_get
    assigns[:votings].should == [@voting]
  end
end

describe VotingsController, "handling GET /votings.xml" do

  before do
    @voting = mock_model(Voting, :to_xml => "XML")
    Voting.stub!(:find).and_return(@voting)
  end
  
  def do_get
    @request.env["HTTP_ACCEPT"] = "application/xml"
    get :index
  end
  
  it "should be successful" do
    do_get
    response.should be_success
  end

  it "should find all votings" do
    Voting.should_receive(:find).with(:all).and_return([@voting])
    do_get
  end
  
  it "should render the found voting as xml" do
    @voting.should_receive(:to_xml).and_return("XML")
    do_get
    response.body.should == "XML"
  end
end

describe VotingsController, "handling GET /votings/1" do

  before do
    @voting = mock_model(Voting)
    Voting.stub!(:find).and_return(@voting)
  end
  
  def do_get
    get :show, :id => "1"
  end

  it "should be successful" do
    do_get
    response.should be_success
  end
  
  it "should render show template" do
    do_get
    response.should render_template('show')
  end
  
  it "should find the voting requested" do
    Voting.should_receive(:find).with("1").and_return(@voting)
    do_get
  end
  
  it "should assign the found voting for the view" do
    do_get
    assigns[:voting].should equal(@voting)
  end
end

describe VotingsController, "handling GET /votings/1.xml" do

  before do
    @voting = mock_model(Voting, :to_xml => "XML")
    Voting.stub!(:find).and_return(@voting)
  end
  
  def do_get
    @request.env["HTTP_ACCEPT"] = "application/xml"
    get :show, :id => "1"
  end

  it "should be successful" do
    do_get
    response.should be_success
  end
  
  it "should find the voting requested" do
    Voting.should_receive(:find).with("1").and_return(@voting)
    do_get
  end
  
  it "should render the found voting as xml" do
    @voting.should_receive(:to_xml).and_return("XML")
    do_get
    response.body.should == "XML"
  end
end

describe VotingsController, "handling GET /votings/new" do

  before do
    @voting = mock_model(Voting)
    Voting.stub!(:new).and_return(@voting)
  end
  
  def do_get
    get :new
  end

  it "should be successful" do
    do_get
    response.should be_success
  end
  
  it "should render new template" do
    do_get
    response.should render_template('new')
  end
  
  it "should create an new voting" do
    Voting.should_receive(:new).and_return(@voting)
    do_get
  end
  
  it "should not save the new voting" do
    @voting.should_not_receive(:save)
    do_get
  end
  
  it "should assign the new voting for the view" do
    do_get
    assigns[:voting].should equal(@voting)
  end
end

describe VotingsController, "handling GET /votings/1/edit" do

  before do
    @voting = mock_model(Voting)
    Voting.stub!(:find).and_return(@voting)
  end
  
  def do_get
    get :edit, :id => "1"
  end

  it "should be successful" do
    do_get
    response.should be_success
  end
  
  it "should render edit template" do
    do_get
    response.should render_template('edit')
  end
  
  it "should find the voting requested" do
    Voting.should_receive(:find).and_return(@voting)
    do_get
  end
  
  it "should assign the found voting for the view" do
    do_get
    assigns[:voting].should equal(@voting)
  end
end

describe VotingsController, "handling POST /votings" do

  before do
    @voting = mock_model(Voting, :to_param => "1")
    Voting.stub!(:new).and_return(@voting)
  end
  
  def post_with_successful_save
    @voting.should_receive(:save).and_return(true)
    post :create, :voting => {}
  end
  
  def post_with_failed_save
    @voting.should_receive(:save).and_return(false)
    post :create, :voting => {}
  end
  
  it "should create a new voting" do
    Voting.should_receive(:new).with({}).and_return(@voting)
    post_with_successful_save
  end

  it "should redirect to the new voting on successful save" do
    post_with_successful_save
    response.should redirect_to(voting_url("1"))
  end

  it "should re-render 'new' on failed save" do
    post_with_failed_save
    response.should render_template('new')
  end
end

describe VotingsController, "handling PUT /votings/1" do

  before do
    @voting = mock_model(Voting, :to_param => "1")
    Voting.stub!(:find).and_return(@voting)
  end
  
  def put_with_successful_update
    @voting.should_receive(:update_attributes).and_return(true)
    put :update, :id => "1"
  end
  
  def put_with_failed_update
    @voting.should_receive(:update_attributes).and_return(false)
    put :update, :id => "1"
  end
  
  it "should find the voting requested" do
    Voting.should_receive(:find).with("1").and_return(@voting)
    put_with_successful_update
  end

  it "should update the found voting" do
    put_with_successful_update
    assigns(:voting).should equal(@voting)
  end

  it "should assign the found voting for the view" do
    put_with_successful_update
    assigns(:voting).should equal(@voting)
  end

  it "should redirect to the voting on successful update" do
    put_with_successful_update
    response.should redirect_to(voting_url("1"))
  end

  it "should re-render 'edit' on failed update" do
    put_with_failed_update
    response.should render_template('edit')
  end
end

describe VotingsController, "handling DELETE /voting/1" do

  before do
    @voting = mock_model(Voting, :destroy => true)
    Voting.stub!(:find).and_return(@voting)
  end
  
  def do_delete
    delete :destroy, :id => "1"
  end

  it "should find the voting requested" do
    Voting.should_receive(:find).with("1").and_return(@voting)
    do_delete
  end
  
  it "should call destroy on the found voting" do
    @voting.should_receive(:destroy)
    do_delete
  end
  
  it "should redirect to the votings list" do
    do_delete
    response.should redirect_to(votings_url)
  end
end
