require File.dirname(__FILE__) + '/../../spec_helper'

describe "/secretary/edit.haml" do
  include SecretariesHelper
  
  before do
    @secretary = mock_model(Secretary)
    @secretary.stub!(:name).and_return("MyString")
    assigns[:secretary] = @secretary
  end

  it "should render edit form" do
    render "/secretaries/edit.haml"
    
    response.should have_tag("form[action=#{secretary_path(@secretary)}][method=post]") do
      with_tag('input#secretary_name[name=?]', "secretary[name]")
    end
  end
end