require File.dirname(__FILE__) + '/../../spec_helper'

describe "/secretaries/new.haml" do
  include SecretariesHelper
  
  before do
    @secretary = mock_model(Secretary)
    @secretary.stub!(:new_record?).and_return(true)
    @secretary.stub!(:name).and_return("MyString")
    assigns[:secretary] = @secretary
  end

  it "should render new form" do
    render "/secretaries/new.haml"
    
    response.should have_tag("form[action=?][method=post]", secretaries_path) do
      with_tag("input#secretary_name[name=?]", "secretary[name]")
    end
  end
end
