﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace FotoAlbum
{
    public partial class Thumbnail : UserControl
    {
        public event EventHandler ImageSelected;

        public Thumbnail()
        {
            InitializeComponent();
        }

        public String imageSource { get; set; }

        public Thumbnail(string imgSource)
        {
            InitializeComponent();
            imageSource = imgSource;
            Uri uri = new Uri(imgSource, UriKind.RelativeOrAbsolute);
            BitmapImage img = new System.Windows.Media.Imaging.BitmapImage(uri);
            ThumbnailImage.SetValue(Image.SourceProperty, img);
        }

        private void ThumbnailImage_MouseEnter(object sender, MouseEventArgs e)
        {
            ZoomInAnim.Begin();
        }

        private void ThumbnailImage_MouseLeave(object sender, MouseEventArgs e)
        {
            ZoomOutAnim.Begin();
        }

        private void ThumbnailImage_MouseLeftButtonDown(object sender,
                                                MouseButtonEventArgs e)
        {
            ImageSelected(this, EventArgs.Empty);
        }
    }
}
