﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace SimpleVideo
{
    public partial class Page : UserControl
    {
        public Page()
        {
            InitializeComponent();

            playToggleButton.Checked += new RoutedEventHandler(playToggleButton_Checked);
            playToggleButton.Unchecked += new RoutedEventHandler(playToggleButton_Unchecked);

            videoElement.CurrentStateChanged += new RoutedEventHandler(videoElement_CurrentStateChanged);
        }

        void playToggleButton_Checked(object sender, RoutedEventArgs e)
        {
            videoElement.Pause();
            playToggleButton.Content = "Abspielen";
        }

        void playToggleButton_Unchecked(object sender, RoutedEventArgs e)
        {
            videoElement.Play();
            playToggleButton.Content = "Anhalten";
        }

        void videoElement_CurrentStateChanged(object sender, RoutedEventArgs e)
        {
            if (videoElement.CurrentState == MediaElementState.Playing)
            {
                infoTextBlock.Text = String.Format("Auflösung: {0}x{1} Pixel", videoElement.NaturalVideoWidth, videoElement.NaturalVideoHeight);
            }
        }
    }
}
