﻿using System;
using System.Threading;

namespace Helpers {

    ////////////////////////////////////////////////////////////////////////////////
    //
    // erzeuge eine eigene Threads ID
    // 
    public class ThreadId {

        private static int noThreads = 0;       // zaehlt die Anzahl der Threads
        [ThreadStatic]
        private static int currentThread = 0;   // threadlokale Thread-Nummer

        // Nummer des aktuellen Threads
        public static int CurrentThread {
            get {
                if (currentThread == 0) {
                    currentThread = Interlocked.Increment(ref noThreads);
                }
                return currentThread;
            }
        }

        // Anzahl der Threads im aktuellen Prozess (aus denen CurrentThread abgefragt wurde)
        public static int NoThreadUsed {
            get {
                return noThreads;
            }
        }
    }
}
