﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading.Tasks;
using System.Diagnostics;

namespace ImageProcessing {
    public partial class Form1 : Form {

        private Image originalImage;

        public Form1() {
            InitializeComponent();
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e) {
            if (checkBox1.Checked)
                pictureBox1.SizeMode = PictureBoxSizeMode.Zoom;
            else
                pictureBox1.SizeMode = PictureBoxSizeMode.Normal;
        }

        private void loadImage_Click(object sender, EventArgs e) {
            if (openFileDialog1.ShowDialog() == DialogResult.OK) {
                Image image = new Bitmap(openFileDialog1.FileName);
                if (image != null) {
                    pictureBox1.Image = image;
                    originalImage = image;
                    EnableOrDisableFormControls(true);
                }
            }
        }

        private void buttonOriginalImage_Click(object sender, EventArgs e) {
            if (originalImage != null) {
                pictureBox1.Image = originalImage;
                EnableOrDisableFormControls(true);
            }
        }


        private void buttonHue_Click(object sender, EventArgs e) {
            Bitmap b = new Bitmap(pictureBox1.Image);
            ProcessAction(() => ImageProcessor.ToHue(b));
        }

        private void buttonHueParallel_Click(object sender, EventArgs e) {
            Bitmap b = new Bitmap(pictureBox1.Image);
            ProcessAction(() => ImageProcessor.ToHueParallel(b));
        }

        private void ProcessAction(Func<Bitmap> action) {
            if (pictureBox1.Image != null) {
                Stopwatch stopWatch = Stopwatch.StartNew();
                EnableOrDisableFormControls(false);
                label1.Text = "processing...";
                Task.Factory.StartNew(action).ContinueWith(t => {
                    label1.Text = "done. time: " + stopWatch.Elapsed.TotalSeconds + " sec";
                    pictureBox1.Image = t.Result;
                    EnableOrDisableFormControls(true);
                }, TaskScheduler.FromCurrentSynchronizationContext());
            }

        }

        private void EnableOrDisableFormControls(bool enable) {
            buttonHue.Enabled = enable;
            buttonHueParallel.Enabled = enable;
            buttonOriginalImage.Enabled = enable;
        }
    }
}
