﻿using System;
using System.Collections.Concurrent;
using System.IO;
using System.Threading.Tasks;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Helpers;

namespace Pipeline {

    // einfaches Pipeline-Beispiel
    class PipelineSample {

        // Interationen des SpinWait für simulierte CPU-Last
        static int SPINITERATIONS = 5000000;   // zum Testen auf verschiedene Werte stellen

        ////////////////////////////////////////////////////////////////////////////////
        //
        // main
        //
        static void Main(string[] args) {

            // eine Task pro Stufen und dazwischen BlockingCollections
            TestRunner.Runtest(() => PipelineLoopTasks.TasksAndBlockingCollections
                (SPINITERATIONS));

            // parallele Pipelines
            TestRunner.Runtest(() => ParallelPipelinesOutOfOrder());
            TestRunner.Runtest(() => ParallelPipelinesAndOrder());
            TestRunner.Runtest(() => ParallelPipelinesOrdering());


            Console.WriteLine();
            Console.WriteLine("done. Press any key.");
            Console.ReadKey();
        }



        ////////////////////////////////////////////////////////////////////////////////
        //
        // Einfacher Test von SimplePipeline.
        // Jede Stufe hängt ihre Nummer an den bearbeiteten String an und gibt diesen 
        // aus.
        //
        public static void ParallelPipelinesOutOfOrder() {

            Stage<string> stage1 = new Stage<string>(
                s => {
                    s += "1"; Console.Write(s + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return s;
                }
            );
            Stage<string> stage2 = new Stage<string>(
                s => {
                    s += "2"; Console.Write(s + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return s;
                }
            );
            Stage<string> stage3 = new Stage<string>(
                s => {
                    s += "3"; Console.Write(s + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return s;
                }
            );

            SimplePipeline<string> pipe = new SimplePipeline<string>(stage1);
            pipe.AddStage(stage2);
            pipe.AddStage(stage3);

            string[] strings = { "A", "B", "C", "D", "E", "F", "G", "H" };

            for (int i = 0; i < strings.Count(); i++) {
                pipe.Process(strings[i]);
            }

            // warte bis die Pipeline vollständig durchgelaufen ist
            pipe.Wait();
            Console.WriteLine("\npipe ended.");

            // hole die Ergebnisse und gib sie aus
            IEnumerable<string> results = pipe.GetResults();
            foreach (string s in results) {
                Console.Write(s + " ");
            }
        }

        ////////////////////////////////////////////////////////////////////////////////
        //
        // SimplePipeline bearbeitet eine Liste von Strings.
        // Am Schuss werden die Ergebnisse geordnet ausgegeben.
        // Dazu muss ein Zaehler durchgereicht werden.
        // Jede Stufe hängt ihre Nummer an den bearbeiteten String an und gibt diesen 
        // aus.
        //
        public static void ParallelPipelinesAndOrder() {

            Stage<Tuple<int, string>> stage1 = new Stage<Tuple<int, string>>(
                t => {
                    Tuple<int, string> result = Tuple.Create(t.Item1, t.Item2 + "1");
                    Console.Write(result.Item2 + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return result;
                }
            );
            Stage<Tuple<int, string>> stage2 = new Stage<Tuple<int, string>>(
                t => {
                    Tuple<int, string> result = Tuple.Create(t.Item1, t.Item2 + "2");
                    Console.Write(result.Item2 + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return result;
                }
            );
            Stage<Tuple<int, string>> stage3 = new Stage<Tuple<int, string>>(
                t => {
                    Tuple<int, string> result = Tuple.Create(t.Item1, t.Item2 + "3");
                    Console.Write(result.Item2 + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return result;
                }
            );

            SimplePipeline<Tuple<int, string>> pipe = new SimplePipeline<Tuple<int, string>>(stage1);
            pipe.AddStage(stage2);
            pipe.AddStage(stage3);

            string[] strings = { "A", "B", "C", "D", "E", "F", "G", "H" };

            for (int i = 0; i < strings.Count(); i++) {
                pipe.Process(Tuple.Create(i, strings[i]));
            }

            // warte bis die Pipeline vollständig durchgelaufen ist
            pipe.Wait();
            Console.WriteLine("\npipe ended.");

            // hole und sortiere die Ergebnisse
            IEnumerable<Tuple<int, string>> results = pipe.GetResults();
            foreach (Tuple<int, string> t in results.OrderBy(t => t.Item1)) {
                Console.Write(t.Item2 + " ");
            }
        }

        ////////////////////////////////////////////////////////////////////////////////
        //
        // Einfacher Test von SimpleOrderingPipeline.
        // Jede Stufe hängt ihre Nummer an den bearbeiteten String an und gibt diesen 
        // aus.
        //
        public static void ParallelPipelinesOrdering() {

            OrderingStage<string> stage1 = new OrderingStage<string>(
                s => {
                    s += "1"; Console.Write(s + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return s;
                }
            );
            OrderingStage<string> stage2 = new OrderingStage<string>(
                s => {
                    s += "2"; Console.Write(s + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return s;
                }
            );
            OrderingStage<string> stage3 = new OrderingStage<string>(
                s => {
                    s += "3"; Console.Write(s + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    return s;
                }
            );

            SimpleOrderingPipeline<string> pipe = new SimpleOrderingPipeline<string>(stage1);
            pipe.AddStage(stage2);
            pipe.AddStage(stage3);

            string[] strings = { "A", "B", "C", "D", "E", "F", "G", "H" };

            for (int i = 0; i < strings.Count(); i++) {
                pipe.Process(strings[i]);
            }

            // warte bis die Pipeline vollständig durchgelaufen ist
            pipe.Wait();
            Console.WriteLine("\npipe ended.");

            // hole die Ergebnisse und gib sie aus
            IEnumerable<string> results = pipe.GetResults();
            foreach (string s in results) {
                Console.Write(s + " ");
            }
        }
    }
}
