﻿using System;
using System.Threading;
using System.Diagnostics;
using System.Linq.Expressions;

namespace Helpers {
    public class TestRunner {

        // Test mit Rueckgabewert ausfuehren
        // (Expression<Func<TResult>> statt Func<TResult> um den Namen der gerufenen Methode 
        // herausfinden zu koennen)
        public static TResult Runtest<TResult>(Expression<Func<TResult>> testee) {
            TResult result;
            var function = testee.Compile();    // get back the method to be called from Expression
            Console.WriteLine("running {0}...", getNameOfCallee(testee));
            Stopwatch stopWatch = Stopwatch.StartNew();
            result = function.Invoke();
            stopWatch.Stop();
            Console.WriteLine();
            Console.WriteLine("result {0}", result);
            Console.WriteLine("time {0}", stopWatch.ElapsedMilliseconds);
            Console.WriteLine();
            return result;
        }


        // Test ohne Rueckgabewert ausfuehren
        // (Expression<Action> statt Action um den Namen der gerufenen Methode 
        // herausfinden zu koennen)
        public static void Runtest(Expression<Action> testee) {
            var action = testee.Compile();  // get back the method to be called from Expression
            Console.WriteLine("running {0}...", getNameOfCallee(testee));
            Stopwatch stopWatch = Stopwatch.StartNew();
            action.Invoke();
            stopWatch.Stop();
            Console.WriteLine();
            Console.WriteLine("time {0}", stopWatch.ElapsedMilliseconds);
            Console.WriteLine();
        }


        // Hilfsmethode, extrahiert Name einer via Lambda-Expression aufgerufenen Methode
        private static string getNameOfCallee(LambdaExpression expression) {
            if (expression.Body.NodeType == ExpressionType.Call) {
                var info = (MethodCallExpression)expression.Body;
                return info.Method.Name;
            }
            return "<no method call>";
        }
    }
}
