﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Collections.Concurrent;
using System.Threading;
using System.Threading.Tasks;

namespace Pipeline {
    static class PipelineLoopTasks {


        // Interationen des SpinWait für simulierte CPU-Last
        public static int SPINITERATIONS = 0;

        ////////////////////////////////////////////////////////////////////////////////
        //
        // einfacher Test
        //
        public static void TasksAndBlockingCollections(int spinIterations) {
            SPINITERATIONS = spinIterations;

            // jede Stage wird in einer eigenen Task gestartet,
            // die Übergabe der Daten erfolgt zwischen den Stages über eine BlockingCollection 
            var stage1Input = new BlockingCollection<string>();
            var stage1Output = new BlockingCollection<string>();
            var stage1 = Task.Factory.StartNew(() => Stage1(stage1Input, stage1Output));

            var stage2Output = new BlockingCollection<string>();
            var stage2 = Task.Factory.StartNew(() => Stage2(stage1Output, stage2Output));

            var stage3Output = new BlockingCollection<string>();
            var stage3 = Task.Factory.StartNew(() => Stage3(stage2Output, stage3Output));

            string[] strings = { "A", "B", "C", "D", "E", "F", "G", "H" };

            for (int i = 0; i < strings.Count(); i++) {
                stage1Input.Add(strings[i]);
            }
            stage1Input.CompleteAdding();  // wichtig!

            // warte bis die Pipeline vollständig durchgelaufen ist
            Task.WaitAll(stage1, stage2, stage3);
            Console.WriteLine("\npipe ended.");

            foreach (string r in stage3Output) {
                Console.Write(r + " ");
            }
        }

        private static void Stage1(BlockingCollection<string> input, BlockingCollection<string> output) {
            try {
                foreach (var s in input.GetConsumingEnumerable()) {
                    string result  = s + "1"; 
                    Console.Write(result + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    output.Add(result);
                };
            } finally { output.CompleteAdding(); }  // wichtig!
        }
        private static void Stage2(BlockingCollection<string> input, BlockingCollection<string> output) {
            try {
                foreach (var s in input.GetConsumingEnumerable()) {
                    string result = s + "2";
                    Console.Write(result + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    output.Add(result);
                };
            } finally { output.CompleteAdding(); }  // wichtig!
        }
        private static void Stage3(BlockingCollection<string> input, BlockingCollection<string> output) {
            try {
                foreach (var s in input.GetConsumingEnumerable()) {
                    string result = s + "3";
                    Console.Write(result + " ");
                    Thread.SpinWait(SPINITERATIONS);   // anstelle einer echten Berechnung
                    output.Add(result);
                };
            } finally { output.CompleteAdding(); }  // wichtig!
        }

    }
}
