﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using iXTanken.Data;

namespace iXTanken
{
    public partial class App : Application
    {
        public List<TankVorgang> TankVorgangListe { get; set; }

        public App()
        {
            UnhandledException += new EventHandler<ApplicationUnhandledExceptionEventArgs>(Application_UnhandledException);

            InitializeComponent();
            TankVorgangListe = new List<TankVorgang>{
                new TankVorgang() {Kilometerstand = 48230.0, Datum = new DateTime(2010,3,10), Betrag=48.50, Menge=39.5, Anmerkung="Testtanke"},
                new TankVorgang() {Kilometerstand = 48980.0, Datum = new DateTime(2010,4,2), Betrag= 52.80, Menge=35.6, Anmerkung="Diesltank"}
            };
        }

        // Code to execute on Unhandled Exceptions
        private void Application_UnhandledException(object sender, ApplicationUnhandledExceptionEventArgs e)
        {
            if (System.Diagnostics.Debugger.IsAttached)
            {
                // An unhandled exception has occurred, break in the debugger
                System.Diagnostics.Debugger.Break();
            }
            else
            {
                // By default show the error
                e.Handled = true;
                MessageBox.Show(e.ExceptionObject.Message + Environment.NewLine + e.ExceptionObject.StackTrace,
                    "Error", MessageBoxButton.OK);
            }
        }
    }
}