/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package guice;

import javax.servlet.ServletContextEvent;

import model.AuthService;
import model.ModelService;
import model.neo4j.Neo4jAuthServiceImpl;

import org.bushe.swing.event.EventService;
import org.bushe.swing.event.ThreadSafeEventService;

import presenter.BookmarkListPresenter;
import presenter.LabelListPresenter;
import presenter.BookmarkListPresenter.BookmarkListView;
import presenter.LabelListPresenter.LabelListView;
import vaadin.BookmarkApp;
import vaadin.BookmarkListPanel;
import vaadin.LabelListPanel;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.google.inject.servlet.ServletScopes;
import com.vaadin.Application;

public class GuiceServletConfig extends GuiceServletContextListener {

	private ModelService modelService = null;
	private Injector injector = null;

	@Override
	public void contextInitialized(ServletContextEvent event) {

		String modelServiceClassName = event.getServletContext()
				.getInitParameter("modelService.factory");

		try {
			modelService = (ModelService) Class.forName(modelServiceClassName)
					.newInstance();
		} catch (final InstantiationException e) {
			throw new ClassFormatError();
		} catch (final IllegalAccessException e) {
			throw new ClassFormatError();
		} catch (final ClassNotFoundException e) {
			throw new ClassFormatError();
		}

		if (modelService != null) {
			event.getServletContext()
					.setAttribute("modelService", modelService);
		}

		super.contextInitialized(event);

	}

	@Override
	public void contextDestroyed(ServletContextEvent event) {
		super.contextDestroyed(event);

		if (modelService != null) {
			modelService.stop();
		}
	}

	@Override
	protected Injector getInjector() {

		ServletModule module = new ServletModule() {
			@Override
			protected void configureServlets() {
				serve("/*").with(GuiceApplicationServlet.class);

				bind(Application.class).to(BookmarkApp.class).in(
						ServletScopes.SESSION);

				bind(EventService.class).to(ThreadSafeEventService.class).in(
						ServletScopes.SESSION);
				bind(LabelListView.class).to(LabelListPanel.class).in(
						ServletScopes.SESSION);
				bind(BookmarkListView.class).to(BookmarkListPanel.class).in(
						ServletScopes.SESSION);

				bind(LabelListPresenter.class).in(ServletScopes.SESSION);
				bind(BookmarkListPresenter.class).in(ServletScopes.SESSION);

				bind(BookMarkItemViewProvider.class).in(ServletScopes.SESSION);
				bind(BookMarkItemFormProvider.class).in(ServletScopes.SESSION);

				bind(AuthService.class).to(Neo4jAuthServiceImpl.class).in(
						ServletScopes.SESSION);
			}

			@SuppressWarnings("unused")
			@Provides
			protected ModelService provideModelService() {
				injector.injectMembers(modelService);
				return modelService;
			}

		};

		injector = Guice.createInjector(module);
		return injector;
	}
}
