/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package guice;

import model.AuthService;
import model.ModelService;
import model.neo4j.Neo4jAuthServiceImpl;
import model.neo4j.Neo4jDatabaseService;
import model.neo4j.Neo4jModelService;

import org.bushe.swing.event.EventService;
import org.bushe.swing.event.ThreadSafeEventService;

import presenter.BookmarkListPresenter;
import presenter.LabelAndBookmarkViewMock;
import presenter.LabelListPresenter;
import presenter.BookmarkListPresenter.BookmarkListView;
import presenter.LabelListPresenter.LabelListView;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;

public class MockTestModule extends AbstractModule {

	private final String dbPath;

	public MockTestModule(final String dbPath) {
		this.dbPath = dbPath;
	}

	@Override
	protected void configure() {

		final Neo4jModelService modelService = new Neo4jModelService(
				new Neo4jDatabaseService(dbPath));
		bind(ModelService.class).toInstance(modelService);
		bind(AuthService.class).to(Neo4jAuthServiceImpl.class).in(
				Singleton.class);

		bind(LabelListView.class).to(LabelAndBookmarkViewMock.class).in(
				Singleton.class);
		bind(LabelListPresenter.class).in(Singleton.class);

		bind(BookmarkListView.class).to(LabelAndBookmarkViewMock.class).in(
				Singleton.class);
		bind(BookmarkListPresenter.class).in(Singleton.class);

		bind(EventService.class).to(ThreadSafeEventService.class).in(
				Singleton.class);

	}
}
