/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package model;

import presenter.dto.BookmarkViewDto;
import presenter.dto.LabelViewDto;

public interface ModelService {

	void getBookmarks(final UserDto userDto);

	void getBookmarks(final UserDto userDto, final LabelDto labelDto);

	void getLabels(final UserDto userDto);

	void getLabels(final BookmarkDto bookmarkDto, final UserDto userDto);

	void addBookmark(final BookmarkDto bookmarkDto, final UserDto userDto);

	void addLabel(final LabelDto labelDto, final UserDto userDto);

	void addAndConnectBookmarkAndLabel(final BookmarkDto bookmarkDto,
			final LabelDto labelDto, final UserDto userDto);

	void update(final BookmarkViewDto bookmarkViewDto, UserDto userDto);

	void update(final LabelViewDto labelViewDto, UserDto userDto);

	void update(final UserDto userDto);

	void delete(final BookmarkDto bookmarkDto, UserDto userDto);

	void delete(final LabelDto labelDto, UserDto userDto);

	void delete(final UserDto userDto);

	void start();

	void stop();

	LabelDto createLabelDto(final String name);

	BookmarkDto createBookmarkDto(final String title, final String uri,
			String description);

}