/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package model.neo4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import model.BookmarkDto;
import model.LabelDto;
import presenter.dto.BookmarkViewDto;
import presenter.dto.LabelViewDto;

class BookmarkDtoImpl extends BaseDtoImpl implements BookmarkDto {

	private final String title;
	private final String uri;
	private final String description;
	private final List<LabelDto> labelDtos;

	public BookmarkDtoImpl(final String title, final String uri,
			final String description) {
		super();
		this.title = title;
		this.uri = uri;
		this.description = description;
		this.labelDtos = Collections.emptyList();
	}

	public BookmarkDtoImpl(final Bookmark bookmark) {
		super(((BookmarkImpl) bookmark).getTheNode().getId());
		this.title = bookmark.getTitle();
		this.uri = bookmark.getUri();
		this.description = bookmark.getDescription();

		this.labelDtos = Collections.emptyList();
	}

	public BookmarkDtoImpl(BookmarkViewDto bookmarkViewDto) {
		super(bookmarkViewDto.getId());
		this.title = bookmarkViewDto.getTitle();
		this.uri = bookmarkViewDto.getUri();
		this.description = bookmarkViewDto.getDescription();

		Collection<LabelViewDto> labels = bookmarkViewDto.getLabels();

		labelDtos = new ArrayList<LabelDto>();
		for (LabelViewDto label : labels) {
			labelDtos.add(new LabelDtoImpl(label));
		}
	}

	public BookmarkDtoImpl(final Bookmark bookmark, final User user) {
		super(((BookmarkImpl) bookmark).getTheNode().getId());
		this.title = bookmark.getTitle();
		this.uri = bookmark.getUri();
		this.description = bookmark.getDescription();

		Collection<Label> labels = bookmark.getLabels(user);

		labelDtos = new ArrayList<LabelDto>();
		for (Label label : labels) {
			labelDtos.add(new LabelDtoImpl(label, user));
		}
	}

	@Override
	public String getTitle() {
		return this.title;
	}

	@Override
	public String getUri() {
		return this.uri;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public List<LabelDto> getLabels() {
		return labelDtos;
	}

}
