/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package model.neo4j;

import model.AuthService;
import model.ModelService;
import model.UserDto;

import com.google.inject.Inject;

public class Neo4jAuthServiceImpl implements AuthService {

	private final Neo4jDatabaseService dbService;
	private UserDto loginUser = null;

	@Inject
	public Neo4jAuthServiceImpl(ModelService modelService) {
		dbService = ((Neo4jModelService) modelService).getDbService();
	}

	@Override
	public UserDto getLoginUser() {
		return this.loginUser;
	}

	@Override
	public boolean login(String username, String password) {

		this.loginUser = new UserDtoImpl(dbService.getOrCreateUser(username));

		return true;
	}

	@Override
	public boolean logout() {

		this.loginUser = null;

		return true;
	}

	@Override
	public UserDto getPublicUser() {
		return new UserDtoImpl(dbService.getPublicUser());
	}

}
