/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package presenter;

import guice.BookMarkItemFormProvider;

import java.util.Collection;

import model.AuthService;
import model.BookmarkDto;
import model.ModelService;

import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.generics.TypeReference;

import presenter.dto.BookmarkViewDto;

import com.google.inject.Inject;

public class BookmarkItemPresenter extends
		PresenterImpl<BookmarkItemPresenter.BookmarkItemView> {

	public interface BookmarkItemView extends View {
		void update(BookmarkViewDto bookmarkViewDto);

		void addForm(BookmarkItemFormView bookmarkItemViewForm);
	}

	public interface BookmarkItemFormView extends View {
		void initData(BookmarkViewDto bookmarkViewDto);
	}

	private class ViewBookmarkItemEventSubscriber implements
			EventSubscriber<BookmarkItemChangeEvent<BookmarkItemView>> {

		@Override
		public void onEvent(BookmarkItemChangeEvent<BookmarkItemView> event) {

			if (BookmarkItemPresenter.this.view.equals(event.getTo())) {
				switch (event.getChangeType()) {
				case EDIT:
					editBookmark(event.getBookmarkViewDto());
					break;

				default:
					break;
				}
			}
		}

	}

	private class ViewBookmarkItemFormEventSubscriber implements
			EventSubscriber<BookmarkItemChangeEvent<BookmarkItemFormView>> {

		private final BookmarkItemFormView bookmarkItemFormView;

		public ViewBookmarkItemFormEventSubscriber(
				BookmarkItemFormView bookmarkItemFormView) {
			this.bookmarkItemFormView = bookmarkItemFormView;
		}

		@Override
		public void onEvent(BookmarkItemChangeEvent<BookmarkItemFormView> event) {

			if (bookmarkItemFormView.equals(event.getTo())) {
				switch (event.getChangeType()) {

				case SAVE:
					saveBookmarkForm(event.getBookmarkViewDto());
					break;
				case CANCEL:
					cancelBookmarkForm(event.getBookmarkViewDto());
					break;

				default:
					break;
				}
			}
		}

	}

	private class ModelEventSubscriber implements EventSubscriber<BookmarkDto> {

		@Override
		public void onEvent(BookmarkDto event) {
			updateData(event);
		}
	}

	private final ModelService modelService;
	private final AuthService authService;
	private final BookMarkItemFormProvider bookmarkItemFormProvider;

	private final ModelEventSubscriber modelEventSubscriber;
	private final ViewBookmarkItemEventSubscriber viewBookmarkItemEventSubscriber;

	private ViewBookmarkItemFormEventSubscriber viewBookmarkItemFormEventSubscriber;

	@Inject
	public BookmarkItemPresenter(BookmarkItemView bmarkItemView,
			BookMarkItemFormProvider bookmarkItemFormProvider,
			ModelService modelService, AuthService authService,
			EventService eventService) {

		super(eventService, bmarkItemView);

		this.bookmarkItemFormProvider = bookmarkItemFormProvider;
		this.modelService = modelService;
		this.authService = authService;

		this.viewBookmarkItemEventSubscriber = new ViewBookmarkItemEventSubscriber();
		eventService.subscribe(BookmarkItemChangeEvent.class,
				viewBookmarkItemEventSubscriber);

		this.modelEventSubscriber = new ModelEventSubscriber();
		eventService.subscribe(new TypeReference<Collection<BookmarkDto>>() {
		}.getType(), modelEventSubscriber);

	}

	public void cancelBookmarkForm(BookmarkViewDto bookmarkViewDto) {
		view.update(bookmarkViewDto);
		eventService.unsubscribe(BookmarkItemChangeEvent.class,
				viewBookmarkItemFormEventSubscriber);
	}

	public void saveBookmarkForm(BookmarkViewDto bookmarkViewDto) {
		modelService.update(bookmarkViewDto, authService.getLoginUser());
		view.update(bookmarkViewDto);
		eventService.unsubscribe(BookmarkItemChangeEvent.class,
				viewBookmarkItemFormEventSubscriber);
	}

	public void editBookmark(BookmarkViewDto bookmarkViewDto) {
		BookmarkItemFormView bookmarkItemFormView = bookmarkItemFormProvider
				.get();

		viewBookmarkItemFormEventSubscriber = new ViewBookmarkItemFormEventSubscriber(
				bookmarkItemFormView);
		eventService.subscribe(BookmarkItemChangeEvent.class,
				viewBookmarkItemFormEventSubscriber);

		bookmarkItemFormView.initData(bookmarkViewDto);
		view.addForm(bookmarkItemFormView);
	}

	private void updateData(BookmarkDto bookmarkDto) {
		// bookmarkView.update(new BookmarkViewDtoImpl(bookmarkDto));
	}

}
