/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package presenter;

import guice.MockTestModule;

import java.util.List;
import java.util.logging.Logger;

import junit.framework.Assert;
import model.AuthService;
import model.BookmarkDto;
import model.LabelDto;
import model.ModelService;
import model.UserDto;

import org.bushe.swing.event.EventService;

import presenter.dto.BookmarkViewDto;
import presenter.dto.LabelViewDto;

import com.google.inject.Guice;
import com.google.inject.Injector;

public class LabelAndBookmarkViewMock implements LabelListPresenter.LabelListView, BookmarkListPresenter.BookmarkListView
{

	private static Logger logger = Logger.getLogger(LabelAndBookmarkViewMock.class.getName());

	private static final Injector injector = Guice.createInjector(new MockTestModule("var/graphdb"));

	private static final AuthService authService = injector.getInstance(AuthService.class);
	
	private static final ModelService modelService = injector.getInstance(ModelService.class);
	private static final EventService eventService = injector.getInstance(EventService.class);

	@SuppressWarnings("unused")
	private static final LabelListPresenter labelPresenter = injector.getInstance(LabelListPresenter.class);
	private static final LabelAndBookmarkViewMock viewLabelMock = injector.getInstance(LabelAndBookmarkViewMock.class);

	@SuppressWarnings("unused")
	private static final BookmarkListPresenter bookmarkPresenter = injector.getInstance(BookmarkListPresenter.class);
	@SuppressWarnings("unused")
	private static final LabelAndBookmarkViewMock viewBookmarkMock = injector.getInstance(LabelAndBookmarkViewMock.class);

	@Override
	public void setLabelData(List<LabelViewDto> labels) {
		StringBuffer strBuf = new StringBuffer();

		for(LabelViewDto label : labels) {
			strBuf.append(label.getName()).append(":").append(label.getCount()).append(' ');
		}

		logger.info(strBuf.toString());
	}

	@Override
	public void setBookmarkData(final List<BookmarkViewDto> bookmarks) {
		StringBuffer strBuf = new StringBuffer();

		for(BookmarkViewDto bookmarksViewDto : bookmarks) {
			strBuf.append('[')
				.append("title:").append(bookmarksViewDto.getTitle()).append(' ')
				.append("uri:").append(bookmarksViewDto.getUri())
				.append(']').append(' ');
		}

		logger.info(strBuf.toString());
	}

	private void fillDb() {
		boolean loginSuccess = authService.login("hans.wurst@gmail.com", "");
		
		if(loginSuccess) {
			final UserDto user = authService.getLoginUser();
			
			final BookmarkDto bmark1 = modelService.createBookmarkDto("www.programmableweb.com", "http://www.programmableweb.com/", "This is a description");
			
			for(String name : "api,rdf,web".split(",")) {
				modelService.addAndConnectBookmarkAndLabel(bmark1, modelService.createLabelDto(name), user);
			}

			final BookmarkDto bmark2 = modelService.createBookmarkDto("Bring existing data to the Semantic Web", "http://www.ibm.com/developerworks/xml/library/x-semweb.html/", "This is a description");
			final LabelDto label2 = modelService.createLabelDto("rdf");
			modelService.addAndConnectBookmarkAndLabel(bmark2, label2, user);

			final BookmarkDto bmark3 = modelService.createBookmarkDto("Model View Presenter – Wikipedia", "http://de.wikipedia.org/wiki/Model_View_Presenter/", "This is a description");
			final LabelDto label3 = modelService.createLabelDto("mvp");
			modelService.addAndConnectBookmarkAndLabel(bmark3, label3, user);

			final BookmarkDto bmark4 = modelService.createBookmarkDto("Hive Development Limited: Google Web Toolkit (GWT) MVP Example", "http://www.atomicobject.com/pages/Presenter+First/", "This is a description");
			final LabelDto label4 = modelService.createLabelDto("mvp");
			modelService.addAndConnectBookmarkAndLabel(bmark4, label4, user);

			final BookmarkDto bmark5 = modelService.createBookmarkDto("A Simple Example: Google Guice Inversion of Control (IoC)", "http://www.theserverside.com/tutorial/A-Simple-Example-Google-Guice-Inversion-of-Control-IoC/", "This is a description");
			final LabelDto label5 = modelService.createLabelDto("dependency injection");
			modelService.addAndConnectBookmarkAndLabel(bmark5, label5, user);

		} else {
			Assert.fail("Login failure...");
		}

	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		try {
			viewLabelMock.fillDb();
			
			eventService.publish(new LabelListChangeEvent(null, ChangeType.INITIALIZE));
			eventService.publish(new BookmarkListChangeEvent(null, ChangeType.INITIALIZE));

		} finally {		
			modelService.stop();
		}
		
	}

	@Override
	public void init() {
		// TODO Auto-generated method stub
		
	}

}
