/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package presenter.dto;

import model.LabelDto;

public class LabelViewDtoImpl implements LabelViewDto {

	private final long id;
	private final String name;
	private final int count;

	public LabelViewDtoImpl(String name) {
		this.id = -1L;
		this.name = name;
		this.count = 0;
	}

	public LabelViewDtoImpl(LabelDto labelDto) {
		this.id = labelDto.getId();
		this.name = labelDto.getName();
		this.count = labelDto.getCount();
	}

	@Override
	public long getId() {
		return id;
	}

	@Override
	public int getCount() {
		return count;
	}

	@Override
	public String getName() {
		return name;
	}

}
