/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package vaadin;

import model.AuthService;
import model.ModelService;

import org.bushe.swing.event.EventService;

import presenter.BookmarkListPresenter;
import presenter.LabelListPresenter;
import presenter.BookmarkListPresenter.BookmarkListView;
import presenter.LabelListPresenter.LabelListView;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.LoginForm;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.LoginForm.LoginEvent;
import com.vaadin.ui.LoginForm.LoginListener;
import com.vaadin.ui.Window.CloseEvent;
import com.vaadin.ui.Window.Notification;

@SuppressWarnings("serial")
public class BookmarkApp extends com.vaadin.Application {

	@Inject
	private Injector injector;

	@Inject
	private AuthService authService;

	@Inject
	private EventService eventService;

	private void initApplication() {

		setMainWindow(new Window("Bookmarks"));
		getMainWindow().getContent().setSizeFull();

		authService = injector.getInstance(AuthService.class);

		LoginForm login = new LoginForm();

		getMainWindow().addComponent(login);

		login.addListener(new LoginListener() {

			@Override
			public void onLogin(LoginEvent event) {
				boolean success = authService.login(event
						.getLoginParameter("username"), event
						.getLoginParameter("password"));

				if (success) {
					injector.getInstance(ModelService.class);
					eventService = injector.getInstance(EventService.class);
					injector.getInstance(LabelListPresenter.class);
					injector.getInstance(BookmarkListPresenter.class);
					initLayout();
				} else {
					getMainWindow().showNotification("Login failure",
							"Login failed...",
							Notification.TYPE_WARNING_MESSAGE);
				}
			}
		});

	}

	private void initLayout() {

		final LabelListPanel labelPanel = (LabelListPanel) injector
				.getInstance(LabelListView.class);
		final BookmarkListPanel bookmarkPanel = (BookmarkListPanel) injector
				.getInstance(BookmarkListView.class);

		GridLayout grid = new GridLayout(5, 5);
		grid.setSpacing(true);
		grid.setMargin(true);
		grid.addStyleName(ThemeConstants.LAYOUT_WHITE);

		VerticalLayout headers = new VerticalLayout();
		Label header = new Label("Bookmarks");
		header.addStyleName(ThemeConstants.LABEL_H1);
		Label subHeader = new Label("by Christoph Leisegang");
		subHeader.addStyleName(ThemeConstants.LABEL_SMALL);
		headers.addComponent(header);
		headers.addComponent(subHeader);

		grid.addComponent(headers, 0, 0);
		VerticalLayout vLayout = new VerticalLayout();
		ToolsPanel tPanel = new ToolsPanel(eventService);
		tPanel.setHeight("120px");
		vLayout.addComponent(tPanel);
		vLayout.addComponent(labelPanel);
		grid.addComponent(vLayout, 0, 1);

		// grid.addComponent(new ToolsPanel(eventService), 0, 1);
		// grid.addComponent(labelPanel, 0, 2, 0, 3);
		grid.addComponent(bookmarkPanel, 1, 1, 4, 2);

		Label footer = new Label("Copyright (C) Christoph Leisegang");
		footer.addStyleName("title");
		grid.addComponent(footer, 0, 4);

		getMainWindow().setContent(grid);
	}

	@Override
	public void init() {

		initApplication();

		// Close the application if the main window is closed.
		getMainWindow().addListener(new Window.CloseListener() {
			@Override
			public void windowClose(CloseEvent e) {
				getMainWindow().getApplication().close();
			}
		});

	}

	@Override
	public void close() {
		super.close();
	}

}
