/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package vaadin;

import java.util.List;

import org.bushe.swing.event.EventService;

import presenter.ChangeType;
import presenter.LabelListChangeEvent;
import presenter.LabelListPresenter.LabelListView;
import presenter.dto.LabelViewDto;

import com.google.inject.Inject;
import com.vaadin.ui.Button;
import com.vaadin.ui.Button.ClickEvent;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;

@SuppressWarnings("serial")
public class LabelListPanel extends VerticalLayout implements LabelListView,
		Button.ClickListener {

	private final EventService eventService;

	private final Panel panel;
	private final Table table;

	@Inject
	public LabelListPanel(EventService eventService) {

		this.eventService = eventService;

		this.panel = new Panel();
		table = new Table();
	}

	@Override
	public void init() {

		setWidth("150px");

		panel.setStyleName(ThemeConstants.PANEL_LIGHT);

		VerticalLayout wLayout = (VerticalLayout) panel.getContent();
		wLayout.setSizeFull();
		wLayout.setMargin(false, false, false, false);

		Label title = new Label("Labels");
		title.addStyleName(ThemeConstants.LABEL_H2);
		addComponent(title);

		table.setSizeFull();
		table.addStyleName(ThemeConstants.TABLE_BORDERLESS);

		table.setColumnHeaderMode(Table.COLUMN_HEADER_MODE_HIDDEN);
		table.setColumnWidth("Label", 100);

		table.addContainerProperty("Label", Button.class, null);
		table.addContainerProperty("Count", Integer.class, null);
		table.setColumnAlignment("Count", Table.ALIGN_RIGHT);

		addComponent(panel);
		panel.addComponent(table);

		this.eventService.publish(new LabelListChangeEvent("",
				ChangeType.INITIALIZE));

	}

	@Override
	public void setLabelData(List<LabelViewDto> labelViewDtos) {

		table.removeAllItems();

		for (LabelViewDto labelViewDto : labelViewDtos) {
			Button button = new Button(labelViewDto.getName());
			button.setStyleName(ThemeConstants.BUTTON_LINK);
			button.addListener(this);

			button.setData(labelViewDto);

			table.addItem(new Object[] { button, labelViewDto.getCount() },
					labelViewDto.getId());
		}
	}

	/*
	 * Shows a notification when a button is clicked.
	 */
	public void buttonClick(ClickEvent event) {
		getWindow().showNotification(
				"link clicked: "
						+ ((LabelViewDto) event.getButton().getData())
								.getName());
	}
}
