﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AzureBlog_Modell;

namespace AzureBlog_Logik
{
 public class BeitragManager : IDisposable
 {
     AzureBlog_Modell.AzureBlogEntities modell = EFContextFactory.Create();


  public Beitrag Create(int AutorID, string Titel, string Text)
  {

   Beitrag b = new Beitrag();
   b.AutorID = AutorID;
   b.Text = Text;
   b.Titel = Titel;
   b.Datum = DateTime.Now;
   modell.Beitrag.AddObject(b);
   modell.SaveChanges();
   return b;
  }

  public List<Beitrag> GetAll()
  {
   return modell.Beitrag.Include("Autor").Include("Kategorie").OrderByDescending(b => b.Datum).ToList();
  }

  public List<Beitrag> GetAll(int AutorID)
  {
   return modell.Beitrag.Include("Autor").Include("Kategorie").Where(b => b.AutorID == AutorID).OrderByDescending(b => b.Datum).ToList();
  }

  public void AddKategorieToBeitrag(int beitragID, int kategorieID)
  {
    var beitrag = modell.Beitrag.Where(x => x.BeitragID == beitragID).SingleOrDefault();
    var kategorie = modell.Kategorie.Where(x => x.KategorieID == kategorieID).SingleOrDefault();

    beitrag.Kategorie.Add(kategorie);


   modell.SaveChanges();

  }

  #region IDisposable Members

  public void Dispose()
  {
   modell.Dispose();
  }

  #endregion
 }
}
