﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AzureBlog_TableServices;
using AzureBlog_Modell;

namespace AzureBlog_Logik
{
    public class KategorieManager 
    {

        private BlogContext ctx = BlogContext.Create();

        public Kategorie MapKategorie(KategorieEntity k) {
            Kategorie result;

            if (k == null) return null;

            result = new Kategorie();
            result.KategorieID = k.KategorieId;
            result.KategorieName = k.KategorieName;

            return result;

        }

        public Kategorie Get(int id)
        {
            KategorieEntity kategorie;

            kategorie = ctx.Kategorien
                .Where(k => k.PartitionKey == id.ToString())
                .FirstOrDefault();

            return MapKategorie(kategorie);
            
        }

        public List<Kategorie> GetAll()
        {
            List<Kategorie> result;
            List<KategorieEntity> kategorien;

            result = new List<Kategorie>();
            kategorien = ctx.Kategorien.ToList();

            foreach (var k in kategorien)
            {
                result.Add(MapKategorie(k));
            }

            return result;
        }

        
    }
}
