﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.StorageClient;

namespace AzureBlog_Logik
{
    public class UploadManager
    {
        CloudBlobContainer container;

        public UploadManager()
        {
            CloudStorageAccount account;
            CloudBlobClient blobClient;
            BlobContainerPermissions permissions;

            account = CloudStorageAccount.FromConfigurationSetting("Storage");
            blobClient = account.CreateCloudBlobClient();
            container = blobClient.GetContainerReference("uploads");

            permissions = new BlobContainerPermissions();
            permissions.PublicAccess = BlobContainerPublicAccessType.Blob;
            container.SetPermissions(permissions);
            container.CreateIfNotExist();
        }

        public void Save(string beitragId, Stream stream, string contentType)
        {
            CloudBlob blob;

            blob = container.GetBlobReference(beitragId);
            blob.UploadFromStream(stream);

            blob.Properties.ContentType = contentType;
            blob.SetProperties();
        }

        public String GetDownloadUrl(string beitragId)
        {
            CloudBlob blob;

            blob = container.GetBlobReference(beitragId);
            return blob.Uri.ToString();
        }

    }
}
