﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AzureBlog_Modell;

namespace AzureBlog_Logik.SqlManager
{
 public class AutorSqlManager : IAutorManager 
 {
     AzureBlog_Modell.AzureBlogEntities modell = EFContextFactory.Create();
      

  public List<Autor> GetAll()
  {
   return modell.Autor.ToList();
  }

  public Autor Get(int AutorID)
  {
   return modell.Autor.Where(b => b.AutorID == AutorID).SingleOrDefault();
  }


  public Autor Get(string EMail)
  {
   return modell.Autor.Where(b => b.EMail.ToLower() == EMail.ToLower()).SingleOrDefault();
  }


  #region IDisposable Members

  public void Dispose()
  {
   modell.Dispose();
  }

  #endregion
 }
}
