﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.Diagnostics;

namespace AzureBlog_Logik
{
    public class WebRole : RoleEntryPoint
    {
        public Action<string, Func<string, bool>> GetConfigurationSettingPublisher() { 
        
            return (configName, configSetter) => 
                configSetter(RoleEnvironment.GetConfigurationSettingValue(configName)); 
        }

        public override bool OnStart()
        {
            CloudStorageAccount.SetConfigurationSettingPublisher(GetConfigurationSettingPublisher());
            return base.OnStart();
        }
    }
}
