﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WrapTools;
using AzureBlog_BlogServiceSampleClient.BlogService;
using System.ServiceModel;
using System.ServiceModel.Web;

namespace AzureBlog_BlogServiceSampleClient
{
    // Nicht ".NET 4.0 Client-Profile", sondern ".NET 4.0" verwenden !!!
    // Benötigt System.ServiceModel.Web und System.Web
    class Program
    {
        const string serviceNamespace = "ix-sample";
        const string scope = "http://localhost/BlogService";

        static void Main(string[] args)
        {
            string username;
            string key;
            AccessControlClient acc;
            string token;
            BlogServiceClient proxy;

            acc = new AccessControlClient(serviceNamespace);

            Console.Write("Username: ");
            username = Console.ReadLine();

            Console.Write("Key: ");
            key = Console.ReadLine();

            token = acc.GetACSToken(username, key, scope);
            Console.WriteLine("Token: " + token);
            Console.WriteLine();

            proxy = new BlogServiceClient();
            

            using (new OperationContextScope(proxy.InnerChannel))
            {

                WebOperationContext.Current.OutgoingRequest.Headers.SetSimpleWebToken(token);

                var entries = proxy.FindAll();

                
                Console.WriteLine("Titel der abgefragten Einträge: ");
                foreach (var entry in entries)
                {
                    Console.WriteLine(entry.Title);
                }

                try
                {
                    string title = "Test-Eintrag von " + username + " am " + DateTime.Now.ToString();
                    proxy.Create(title, "test");
                    Console.WriteLine();
                    Console.WriteLine("Test-Eintrag hinzugefügt");
                }
                catch (Exception e)
                {
                    Console.ForegroundColor = ConsoleColor.Red;
                    Console.WriteLine(e.Message);
                    Console.ForegroundColor = ConsoleColor.Gray;
                }

            }


            Console.WriteLine("<ende>");
            Console.ReadLine();
            

        }
    }
}
