﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AzureBlog_Modell;
using AzureBlog_TableServices;

namespace AzureBlog_Logik
{
    public class BeitragManager 
    {
        private BlogContext ctx = BlogContext.Create();

        public List<Beitrag> GetAll(string autorID)
        {
            List<BeitragEntity> beitraege;

            beitraege = ctx.Beitraege
                            .Where(b => b.PartitionKey == autorID)
                            .ToList();

            return MapBeitraege(beitraege);
        }

        public Beitrag Create(string autorID, string titel, string text)
        {
            BeitragEntity beitrag;
            double timeKey;

            timeKey = DateTime.MaxValue.Subtract(DateTime.Now).TotalSeconds;

            beitrag = new BeitragEntity();

            beitrag.BeitragID = timeKey + "-" + Guid.NewGuid().ToString();
            beitrag.AutorID = autorID;
            beitrag.Titel = titel;
            beitrag.Text = text;
            beitrag.Datum = DateTime.Now;

            ctx.AddBeitrag(beitrag);
            ctx.SaveChanges();

            return MapBeitrag(beitrag);
        }
        
        private Beitrag MapBeitrag(BeitragEntity beitrag) {
            Beitrag result;

            UploadManager um;

            if (beitrag == null) return null;

            result = new Beitrag();
            result.AutorID = beitrag.AutorID;
            result.BeitragID = beitrag.BeitragID;
            result.Datum = beitrag.Datum;
            result.Text = beitrag.Text;
            result.Titel = beitrag.Titel;

            um = new UploadManager();
            string url = um.GetDownloadUrl(result.BeitragID);
            result.AnhangUrl = url;
            

            return result;
        }

        private Beitrag MapBeitragWithAssociations(BeitragEntity entity)
        {
            var beitraege = MapBeitraege(new List<BeitragEntity> { entity });
            if (beitraege.Count == 0) return null;
            return beitraege[0];
        }

        private List<Beitrag> MapBeitraege(List<BeitragEntity> beitraege)
        {
            List<Beitrag> result;
            Dictionary<string, Autor> autoren;
            Dictionary<string, Kategorie> kategorien;
            Beitrag beitrag;

            result = new List<Beitrag>();
            autoren = LoadAutoren();
            kategorien = LoadKategorien();

            foreach (var b in beitraege)
            {
                beitrag = MapBeitrag(b);

                if (autoren.ContainsKey(beitrag.AutorID))
                {
                    beitrag.Autor = autoren[beitrag.AutorID];
                }
                else
                {
                    beitrag.Autor = new Autor()
                    {
                        AutorID = beitrag.AutorID,
                        Nachname = beitrag.AutorID
                    };
                }

                MapKategorien(beitrag, kategorien);
                result.Add(beitrag);
            }

            return result;

        }

        private void MapKategorien(Beitrag beitrag, Dictionary<string, Kategorie> kategorien)
        {
            List<BeitragKategorieLink> links;

            beitrag.Kategorie = new List<Kategorie>();

            links = ctx.BeitragKategorieLinks
                    .Where(link => link.PartitionKey == beitrag.BeitragID)
                    .ToList();

            foreach (var link in links)
            {
                beitrag.Kategorie.Add(kategorien[link.KategorieID]);
            }

        }

        public void AddKategorieToBeitrag(string beitragID, string kategorieID)
        {
            BeitragKategorieLink link;

            link = new BeitragKategorieLink();
            link.BeitragID = beitragID;
            link.KategorieID = kategorieID;

            ctx.AddBeitragKategorieLink(link);
            ctx.SaveChanges();
        }



        public List<Beitrag> GetAll()
        {
            List<BeitragEntity> beitraege;
            beitraege = ctx.Beitraege.ToList();

            return MapBeitraege(beitraege);
            
        }

        public Beitrag GetById(string beitragId, string autorId)
        {
            BeitragEntity entity;

            entity = ctx.Beitraege
                        .Where(
                            b => b.RowKey == beitragId
                                && b.PartitionKey == autorId)
                        .SingleOrDefault();

            return MapBeitragWithAssociations(entity);
        }



        private Dictionary<string, Kategorie> LoadKategorien()
        {
            Dictionary<string, Kategorie> result;
            KategorieManager km;
                
            result = new Dictionary<string,Kategorie>();

            km = new KategorieManager();
            var kategorien = km.GetAll();
            
            foreach(var k in kategorien) {
                result[k.KategorieID] = k;
            }

            return result;
        }

        private Dictionary<string, Autor> LoadAutoren()
        {
            Dictionary<string, Autor> result;
            AutorManager am;

            result = new Dictionary<string, Autor>();

            am = new AutorManager();
            var autoren = am.GetAll();

            foreach (var a in autoren)
            {
                result[a.AutorID] = a;
            }

            return result;
        }


     
        
    }
}
