﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AzureBlog_Logik;
using AzureBlog_Modell;

namespace AzureBlog_Web.Account
{
 public partial class NeuerBeitrag : System.Web.UI.Page
 {
  protected void Page_Load(object sender, EventArgs e)
  {

      if (!User.Identity.IsAuthenticated) Server.Transfer("mustlogin.aspx");
   if (!Page.IsPostBack)
   {
        KategorieManager km = new KategorieManager();
   
        this.C_Kategorien.DataSource = km.GetAll();
        this.C_Kategorien.DataBind();
   
   }
  }

  protected void C_Speichern_Click(object sender, EventArgs e)
  {
      BeitragManager bm;
      string autor;
      Beitrag b;
      UploadManager um;
      BeitragQueueManager bqm;

      bm = new BeitragManager();
      um = new UploadManager();
      bqm = new BeitragQueueManager();

      autor = System.Threading.Thread.CurrentPrincipal.Identity.Name;

      b = bm.Create(autor, this.C_Titel.Text, this.C_Text.Text);

      foreach (ListItem i in this.C_Kategorien.Items)
      {
        if (i.Selected) bm.AddKategorieToBeitrag(b.BeitragID, i.Value);
      }

      if (FileUpload.HasFile)
      {
          var stream = FileUpload.PostedFile.InputStream;
          um.Save(b.BeitragID, stream, FileUpload.PostedFile.ContentType);
      }

      bqm.Send(b.BeitragID, autor);

      this.C_Ergebnis.Text = "Beitrag gespeichert unter ID " + b.BeitragID + "!";
  }
 }
}