﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel.Web;
using System.ServiceModel;

namespace WrapTools
{
    // Benötigt System.ServiceModel.Web
    class ActionWrapAuthorizationManager: AbstractWrapAuthorizationManager
    {


        public ActionWrapAuthorizationManager()
        {
            string issuerName = "https://ix-sample.accesscontrol.windows.net/";
            string trustedAudienceValue = "http://localhost/BlogService";
            string trustedSigningKeyAsString = "YF/3t+ZYbFkON1IWYvIdyqx7gqhQUYp47jHwV91lHgM=";

            byte[] trustedSigningKey = Convert.FromBase64String(trustedSigningKeyAsString);
            base.Init(issuerName, trustedAudienceValue, trustedSigningKey);
        }

        protected override bool CheckAccess(Dictionary<string, string> claims)
        {

            // Prüfen, ob Action-Claim existiert
            string actionClaimValue;
            if (!claims.TryGetValue("Action", out actionClaimValue))
            {
                return false;
            }

            // Falls Claim mehrere Werte hat: splitten
            string[] actions = actionClaimValue.ToLower().Split(',');

            // Erwarteten Wert für Action-Claim ermitteln
            string operationName = OperationContext.Current.IncomingMessageHeaders.Action.Split('/').Last();
            //string requiredActionClaimValue = WebOperationContext.Current.IncomingRequest.UriTemplateMatch.RelativePathSegments.First();

            // Prüfen, ob gewünschter Wert vorhanden ist
            if (!actions.Contains(operationName.ToLower()))
            {
                return false;
            }

            return true;
        }
    }
}
