﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.StorageClient;
using System.Threading;
using System.Diagnostics;

namespace AzureBlog_Logik
{
    public class BeitragQueueManager
    {
        private CloudQueue profileQueue;

        public BeitragQueueManager()
        {
            CloudStorageAccount acnt;
            CloudQueueClient queueClient;

            acnt = CloudStorageAccount.FromConfigurationSetting("Storage");
            queueClient = new CloudQueueClient(acnt.QueueEndpoint, acnt.Credentials);
            profileQueue = queueClient.GetQueueReference("beitrag-queue");
            profileQueue.CreateIfNotExist();
        }

        public void Send(string beitragId, string autorId)
        {
            CloudQueueMessage msg;

            msg = new CloudQueueMessage("NeuerBeitrag: " + beitragId + " " + autorId);
            profileQueue.AddMessage(msg);
        }

        public void Receive(Action<string> process)
        {
            CloudQueueMessage msg = null;
            string content = null;

            while (content == null)
            {
                msg = profileQueue.GetMessage();
                if (msg == null)
                {
                    Thread.Sleep(1000);
                    continue;
                }

                if (msg.DequeueCount > 10)
                {
                    profileQueue.DeleteMessage(msg);
                    continue;
                }

                content = msg.AsString;
            }

                process(content);

                profileQueue.DeleteMessage(msg);
            
        }
    }
}
