﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;
using System.Collections.Specialized;

namespace WrapTools
{
    public class AccessControlClient
    {
        private string ServiceNamespace;
        private string AcsHostName;

        public AccessControlClient(string serviceNamespace, string acsHostName = "accesscontrol.windows.net")
        {
            this.ServiceNamespace = serviceNamespace;
            this.AcsHostName = acsHostName;
        }

        public string GetACSToken(string issuerName, string issuerKey, string scope)
        {
            try
            {
                return _GetACSToken(issuerName, issuerKey, scope);
            }
            catch (WebException ex)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                if (ex.Response != null)
                {
                    Stream exception = ex.Response.GetResponseStream();
                    StreamReader reader = new StreamReader(exception);
                    throw new Exception(
                                ex.GetType().ToString() + ": "
                                    + ex.Message + "\n"
                                    + reader.ReadToEnd());
                }
                else
                {
                    throw ex;
                }
            }
        }

        private string _GetACSToken(string issuerName, string issuerKey, string scope)
        {
            // request a token from AppFabric AC
            WebClient client = new WebClient();
            client.BaseAddress = string.Format("https://{0}.{1}", ServiceNamespace, AcsHostName);

            NameValueCollection values = new NameValueCollection();
            values.Add("wrap_name", issuerName);
            values.Add("wrap_password", issuerKey);
            values.Add("wrap_scope", scope);

            byte[] responseBytes = client.UploadValues("WRAPv0.9", "POST", values);

            string response = Encoding.UTF8.GetString(responseBytes);

            return response
                .Split('&')
                .Single(value => value.StartsWith("wrap_access_token=", StringComparison.OrdinalIgnoreCase))
                .Split('=')[1];
        }

    }
}
