package de.heise.ix.jaxrs.extended;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.RuntimeDelegate;

import org.json.simple.JSONArray;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;

public class PersonResourceImpl implements PersonResource {
	PersonManager manager = PersonManager.getInstance();
		
	@Override
	public Response createPerson(UriInfo uriInfo, Person person) {
		System.out.print("Create person [person=" + person + "] ... ");
		
		try {
			person = manager.savePerson(person);
		}
		catch (Exception e) {
			return Response.status(Status.BAD_REQUEST).build();
		}
		
		UriBuilder builder = uriInfo.getAbsolutePathBuilder();
		URI personURI = builder.path(String.valueOf(person.getPersonID())).build();

		System.out.println("finished!");
		
		return Response.created(personURI).build();		
	}
	
	@Override
	public Person readPerson(long personID) {
		System.out.print("Read person [personID=" + personID + "] ... ");
		
		Person person = null;
		try {
			person = manager.getPerson(personID);
		}
		catch (Exception e) {}
		
		System.out.println("finished!");
		
		return person;
	}
	
	@Override
	public void updatePerson(long personID, Person person) {
		System.out.print("Update person [personID=" + personID + ", person=" + person + "] ... ");

		person.setPersonID(personID);
		
		try {
			manager.updatePerson(person);
		}
		catch (Exception e) {
			throw new WebApplicationException(Status.BAD_REQUEST);
		}
		
		System.out.println("finished!");		
	}
	
	@Override
	public void deletePerson(long personID) {
		System.out.print("Delete person [personID=" + personID + "] ... ");

		Person person = new Person();
		person.setPersonID(personID);
		
		try {
			manager.deletePerson(person);
		}
		catch (Exception e) {
			throw new WebApplicationException(Status.BAD_REQUEST);
		}
		
		System.out.println("finished!");		
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public String getAllPersons(int maxNumber) {
		System.out.print("Get all Persons [maxNumber=" + maxNumber + "] ... ");
		
		Collection<Person> collection = manager.getAllPersons();
		
		JSONArray jsonArray = new JSONArray();
		
		for (Person person : collection) {
			if (jsonArray.size() < maxNumber) {
				jsonArray.add(person.toJSONObject());
			}
			else {
				break;
			}
		}
		
		System.out.println("finished!");		
		
		return jsonArray.toString();
	}
	
    public static void main(String[] args) throws Exception {
    	HttpServer server = HttpServer.create(new InetSocketAddress(8080), 10);
    	HttpContext context = server.createContext("/jaxrs");

    	HttpHandler handler = RuntimeDelegate.getInstance().createEndpoint(new PersonResourceApplication(), HttpHandler.class);
    	context.setHandler(handler);
    	
    	server.start();
    	
		// Warte auf ENTER ...
		System.in.read();
		
		server.stop(0);
	}	
}