package de.heise.ix.jaxrs.simple;

import java.net.InetSocketAddress;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.RuntimeDelegate;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;

@Path("/echo")
public class EchoResource {
    @GET
    @Produces("text/plain")
   	public String echo(@QueryParam("text") String text) {
   		System.out.println(text);
   		return text;
   	}
    
    public static void main(String[] args) throws Exception {
    	HttpServer server = HttpServer.create(new InetSocketAddress(8080), 10);
    	HttpContext context = server.createContext("/jaxrs");

    	HttpHandler handler = RuntimeDelegate.getInstance().createEndpoint(new EchoResourceApplication(), HttpHandler.class);
    	context.setHandler(handler);
    	
    	server.start();
    	
		// Warte auf ENTER ...
		System.in.read();
		
		server.stop(0);
	}
}