package de.heise.ix.jaxws.extended;

import javax.jws.HandlerChain;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;

@WebService
@HandlerChain(file="registration-handler-chain.xml")
public interface RegistrationWS {
	@WebMethod(operationName="register")
	public @WebResult(name="personid") long registerPerson(@WebParam(name="person") Person person) throws RegistrationException;
	
	@WebMethod(operationName="unregister")
	public void unregisterPerson(@WebParam(name="personid") long personID) throws RegistrationException;
	
	@Oneway
	public void sendMailToPerson(@WebParam(name="personid") long personID);
	
	public @WebResult(name="statistics") RegistrationStatistics calculateStatisticsForAllPersons();
}