package de.heise.ix.jaxws.extended;

import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;

public class RegistrationWSClientDynamicService {
	private static final Clock clock = new Clock();
	
	public static void main(String[] args) throws Exception {
		URL wsdl = new URL("http://localhost:8080/jaxws/registration?wsdl");
		QName serviceName = new QName("http://extended.jaxws.ix.heise.de/", "RegistrationWSService");
			
		Service service = Service.create(wsdl, serviceName);
		RegistrationWS registrationWS = service.getPort(RegistrationWS.class);

		// Register person ...
		Person person = Person.getInstanceWithExampleData();			
		long personID = registrationWS.registerPerson(person);
		
		// Send mail to person ...
		clock.markStartPoint();
		registrationWS.sendMailToPerson(personID);
		clock.markEndPoint();

		System.out.println("sendMailToPerson() returned after " + clock.getElapsedTime() + " ms!");
		
		// Unregister person ...
		registrationWS.unregisterPerson(personID);
	}
}