package de.heise.ix.jaxws.extended;

import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;

import de.heise.ix.jaxws.extended.generated.CalculateStatisticsForAllPersonsResponse;
import de.heise.ix.jaxws.extended.generated.RegistrationStatistics;
import de.heise.ix.jaxws.extended.generated.RegistrationWS;
import de.heise.ix.jaxws.extended.generated.RegistrationWSService;

public class RegistrationWSClientGeneratedStub {
	private static final Clock clock = new Clock();
		
	public static void main(String[] args) throws Exception {
		RegistrationWSService service = new RegistrationWSService();
		RegistrationWS registrationWS = service.getRegistrationWSPort();
	
		// Calculate statistics for all persons using response ...
		clock.markStartPoint();
		Response<CalculateStatisticsForAllPersonsResponse> response = registrationWS.calculateStatisticsForAllPersonsAsync();
		clock.markEndPoint();
		
		System.out.println("calculateStatisticsForAllPersonsAsync() using response returned after " + clock.getElapsedTime() + " ms!");
		
		while (!response.isDone()) {
			Thread.sleep(1000);
		}
		clock.markEndPoint();
		
		System.out.println("calculateStatisticsForAllPersonsAsync() using response finished after " + clock.getElapsedTime() + " ms!");
		
		RegistrationStatistics statistics = response.get().getStatistics();
		
		System.out.println("Statistics calculated! => " + statistics.getRegisteredPersons() + " registered persons");

		// Calculate statistics for all persons using handler ...
		clock.markStartPoint();
		registrationWS.calculateStatisticsForAllPersonsAsync(new AsyncHandler<CalculateStatisticsForAllPersonsResponse>() {
			public void handleResponse(Response<CalculateStatisticsForAllPersonsResponse> response) {
				clock.markEndPoint();
				
				System.out.println("calculateStatisticsForAllPersonsAsync() using handler finished after " + clock.getElapsedTime() + " ms!");				

				try {
					RegistrationStatistics statistics = response.get().getStatistics();
					
					System.out.println("Statistics calculated! => " + statistics.getRegisteredPersons() + " registered persons");
				}
				catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		clock.markEndPoint();

		System.out.println("calculateStatisticsForAllPersonsAsync() using handler returned after " + clock.getElapsedTime() + " ms!");

		// Wait on Enter ...
		System.in.read();
	}
}