package de.heise.ix.jaxws.extended;

import java.net.InetSocketAddress;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;

@WebService (serviceName="RegistrationWSService",
		     portName="RegistrationWSPort",
		     endpointInterface="de.heise.ix.jaxws.extended.RegistrationWS")
public class RegistrationWSImpl implements RegistrationWS {
	private PersonManager manager; 
	
	@PostConstruct
	public void setUp() {
		System.out.println("Set up registration service ...");
		
		manager = PersonManager.getInstance();
	}
	
	@PreDestroy
	public void tearDown() {
		System.out.println("Tear down registration service ...");
		
		manager = null;
	}
	
	@Override
	public long registerPerson(Person person) throws RegistrationException {
		System.out.print("Register person [person=" + person + "] ... ");
		
		try {
			person = manager.savePerson(person);
		}
		catch (Exception e) {
			throw new RegistrationException("Can't register person!", e);
		}
		
		System.out.println("finished!");
		
		return person.getPersonID();
	}

	@Override
	public void unregisterPerson(long personID) throws RegistrationException {
		System.out.print("Unregister person [personID=" + personID + "] ... ");
		
		Person person = new Person();
		person.setPersonID(personID);
		
		try {
			manager.deletePerson(person);
		}
		catch (Exception e) {
			throw new RegistrationException("Can't unregister person!", e);
		}

		System.out.println("finished!");
	}

	@Override
	public void sendMailToPerson(long personID) {
		System.out.print("Send mail to person [personID=" + personID + "] ... ");
		
		@SuppressWarnings("unused")
		Person person;
		try {
			person = manager.getPerson(personID);
		}
		catch (Exception e) {}
		
		// TODO: ADD FUNCTIONALITY HERE!
		
		try {
			Thread.sleep(5000);
		}
		catch (InterruptedException ie) {}
		
		System.out.println("finished!");		
	}

	@Override
	public RegistrationStatistics calculateStatisticsForAllPersons() {
		System.out.print("Calculate statistics for all persons ... ");

		RegistrationStatistics statistics = new RegistrationStatistics();		
		statistics.setRegisteredPersons(manager.getAllPersons().size());
		
		// TODO: ADD FUNCTIONALITY HERE!
		
		try {
			Thread.sleep(10000);
		}
		catch (InterruptedException ie) {}
		
		System.out.println("finished!");		

		return statistics;
	}

	public static void main(String[] args) throws Exception {
		HttpServer server = HttpServer.create(new InetSocketAddress(8080), 10);
		HttpContext context = server.createContext("/jaxws/registration");
		
		Endpoint endpoint = Endpoint.create(new RegistrationWSImpl());
		endpoint.publish(context);
		
		server.start();

		// Wait on Enter ...
		System.in.read();
			
		endpoint.stop();
		server.stop(0);
	}
}