package de.heise.ix.jaxws.simple;

import javax.jws.WebService;
import javax.xml.ws.Endpoint;

@WebService (serviceName="EchoWSService",
		     portName="EchoWSPort",
		     endpointInterface="de.heise.ix.jaxws.simple.EchoWS")
public class EchoWSImpl implements EchoWS {
	@Override
	public String echo(String text) {
		System.out.println(text);
		return text;
	}
	
	public static void main(String[] args) throws Exception {
		Endpoint endpoint = Endpoint.publish("http://localhost:8080/jaxws/echo", new EchoWSImpl());
		
		// Wait on Enter ...
		System.in.read();
		
		endpoint.stop();
	}
}
