package ix;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import java.util.Arrays;
import java.util.List;

import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.assertThat;

@RunWith(Parameterized.class)
public class ParameterizedTest {

    @Parameters
    public static List<Object[]> testData() {
   		return Arrays.asList(
            new Object[] { "foo", "FOO" },
            new Object[] { "für", "FÜR" },
            new Object[] { "daß", "DASS" }
        );
   	}

    private String input;
    private String expectedOutput;

    public ParameterizedTest(String input, String expectedOutput) {
        this.input = input;
        this.expectedOutput = expectedOutput;
    }

    @Test
    public void testStringToUpperCase() {
        assertThat(input.toUpperCase(), is(equalTo(expectedOutput)));
    }
}
