package com.thomaskuenneth.artikel.ix;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;

public class JLayerDemo extends JFrame {

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                new JLayerDemo().setVisible(true);
            }
        });
    }

    public JLayerDemo() {
        super("JLayerDemo");
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        // ein Textfeld
        final JTextField tf = new JTextField(30);
        // LayerUI instantiieren
        LayerUI<JTextField> layerUI = new LayerUI<JTextField>() {

            @Override
            public void installUI(JComponent c) {
                super.installUI(c);
                ((JLayer) c).setLayerEventMask(AWTEvent.MOUSE_EVENT_MASK);
            }

            @Override
            public void uninstallUI(JComponent c) {
                super.uninstallUI(c);
                ((JLayer) c).setLayerEventMask(0);
            }

            @Override
            public void eventDispatched(AWTEvent e, JLayer<? extends JTextField> l) {
                super.eventDispatched(e, l);
                if (((MouseEvent) e).getButton() == MouseEvent.BUTTON1) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }

            @Override
            public void paint(Graphics g, JComponent c) {
                super.paint(g, c);
                int len = tf.getDocument().getLength();
                if (len == 0) {
                    g.setColor(Color.red);
                    int y = ((c.getHeight() - g.getFontMetrics().getHeight()) / 2) + g.getFontMetrics().getAscent();
                    g.drawString("bitte Text eingeben", 3, y);
                }
            }
        };
        // JLayer instantiieren und dem Panel hinzufügen
        JLayer<JTextField> layer = new JLayer<>(tf, layerUI);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(layer);
        setContentPane(panel);
        pack();
    }
}