package com.thomaskuenneth.artikel.ix;

import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;

/**
 * Gibt die Java-Version sowie das standardmäßig verwendete Look and Feel aus
 */
public class LookAndFeelInfo {

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                setNimbusLAF();
                System.out.println(System.getProperty("java.version", "???"));
                LookAndFeel laf = UIManager.getLookAndFeel();
                if (laf != null) {
                    System.out.println(laf.getName());
                    if (laf instanceof javax.swing.plaf.metal.MetalLookAndFeel) {
                        System.out.println(MetalLookAndFeel.getCurrentTheme().getName());
                    }
                    System.out.println(laf.getDescription());
                    System.out.println(laf.getClass());
                }
            }
        });
    }

    private static void setNimbusLAF() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
//		} catch (UnsupportedLookAndFeelException e) {
            // Ausnahme behandeln
//		} catch (ClassNotFoundException e) {
            // Ausnahme behandeln
//		} catch (InstantiationException e) {
            // Ausnahme behandeln
//		} catch (IllegalAccessException e) {
            // Ausnahme behandeln
        } catch (UnsupportedLookAndFeelException | ClassNotFoundException | InstantiationException | IllegalAccessException e) {
            // Ausnahme behandeln
        }
    }
}
