package com.thomaskuenneth.artikel.ix;

import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsDevice.WindowTranslucency;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;

@SuppressWarnings("serial")
public class WindowOpacityDemo1 extends JFrame {

    private final JSlider slider;

    public static void main(String[] args) {
        // Initialisierung der GUI immer auf dem EDT
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                // Steht Transparenz auf Fensterebene zur Verfügung?
                GraphicsEnvironment ge =
                        GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = ge.getDefaultScreenDevice();
                if (gd.isWindowTranslucencySupported(WindowTranslucency.TRANSLUCENT)) {
                    WindowOpacityDemo1 frame = new WindowOpacityDemo1();
                    frame.setVisible(true);
                } else {
                    System.err.println("WindowTranslucency.TRANSLUCENT nicht unterstützt");
                    System.exit(1);
                }
            }
        });
    }

    public WindowOpacityDemo1() {
        super("WindowOpacityDemo1");
        setResizable(false);
        setUndecorated(true);
        // Benutzeroberfläche zusammensetzen
        JPanel cp = new JPanel(new FlowLayout(FlowLayout.LEADING, 10, 10));
        // Slider für Werte zwischen 25 und 100
        slider = new JSlider(JSlider.VERTICAL, 25, 100, 90);
        cp.add(slider);
        // Schaltfläche zum Übernehmen des aktuellen Slider-Werts
        JButton button = new JButton("Übernehmen");
        button.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                updateOpacity();
            }
        });
        cp.add(button);
        // Schaltfläche zum Beenden des Programms
        JButton button2 = new JButton("Beenden");
        button2.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        cp.add(button2);
        // neue Content Pane setzen
        setContentPane(cp);
        pack();
        setLocation(100, 100);
        // erstmals voreingestellten Wert setzen
        updateOpacity();
    }

    private void updateOpacity() {
        // 0.0 bedeutet durchsichtig, 1.0 undurchsichtig
        float opacity = (float) slider.getValue() / 100f;
        setOpacity(opacity);
    }
}
